% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/febr2sse.R
\name{febr2sse}
\alias{febr2sse}
\title{Conversion between FEBR and SmartSolos Expert (SSE) soil profile data formats}
\usage{
febr2sse(profiles, horizons, file, ...)
}
\arguments{
\item{profiles}{Data frame with soil profile data, i.e. observation locations.}

\item{horizons}{Data frame with soil horizon data, i.e. sampling layers.}

\item{file}{(optional) Character string naming the JSON file to be written to disk.}

\item{...}{(optional) Arguments passed to \code{\link[base:writeLines]{base::writeLines()}}.}
}
\value{
An object of class \code{character} containing a unicode JSON string.
}
\description{
Export FEBR soil profile data to the JSON file format required by the SmartSolos
Expert API.
}
\examples{
# Toy example
pro <- data.frame(
  evento_id_febr = "Perfil-1",
  taxon_sibcs_1999 = "Argissolo",
  stringsAsFactors = FALSE
)
hor <- data.frame(
  evento_id_febr = rep("Perfil-1", 3),
  camada_id = c("Ap", "B1", "B2"),
  profund_sup = c(0, 16, 32),
  profund_inf = c(16, 32, 50),
  cor_matriz_umido_munsell = rep("5YR 3/3", 3),
  cor_matriz_seco_munsell = rep("5YR 3/3", 3),
  estrutura_tipo = rep("blocos subangulares", 3),
  estrutura_grau = rep("moderada", 3),
  estrutura_cdiam = rep("média", 3),
  consistencia_umido = rep("friável", 3),
  consistencia_seco = rep("duro", 3),
  plasticidade = rep("plástico", 3),
  pegajosidade = rep("pegajoso", 3),
  stringsAsFactors = FALSE
)
febr2sse(pro, hor, tempfile(fileext = ".json"))

# Real example
if (interactive()) {
profiles <- observation(
  data.set = "ctb0025", variable = c("taxon_sibcs", "relevo_drenagem"),
  standardization = list(units = TRUE, round = TRUE))
idx <- profiles$evento_id_febr[1]
profiles <- profiles[profiles$evento_id_febr \%in\% idx, ]
horizons <- layer(
  data.set = "ctb0025", variable = "all",
  standardization =
    list(plus.sign = "remove", lessthan.sign = "remove",
         transition = "smooth", units = TRUE, round = TRUE))
horizons <- horizons[horizons$evento_id_febr \%in\% idx, ]
horizons[, 9:48] <- lapply(horizons[, 9:48], as.numeric)
horizons <- cbind(
  horizons,
  morphology(x = horizons$morfologia_descricao, variable = "color"),
  morphology(x = horizons$morfologia_descricao, variable = "structure"),
  morphology(x = horizons$morfologia_descricao, variable = "consistence"),
  stringsAsFactors = FALSE)
file <- ifelse(
  dir.exists("tmp"),
  paste0("tmp/febr2smartsolos-", idx, ".json"),
  paste0(tempdir(), "/febr2smartsolos-", idx, ".json"))
febr2sse(profiles, horizons, file)
}
}
\references{
Jeroen Ooms (2014). The jsonlite Package: A Practical and Consistent
Mapping Between JSON Data and R Objects. arXiv:1403.2805 [stat.CO]
URL \url{https://arxiv.org/abs/1403.2805}.
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
