% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedstat_post_data_ids_filtered.R
\name{fedstat_post_data_ids_filtered}
\alias{fedstat_post_data_ids_filtered}
\title{Post data filters ids to fedstat.ru and download specified subset of data}
\usage{
fedstat_post_data_ids_filtered(
  data_ids,
  data_format = c("sdmx", "excel"),
  timeout_seconds = 180,
  retry_max_times = 3,
  httr_verbose = httr::verbose(data_out = FALSE)
)
}
\arguments{
\item{data_ids}{data.frame, can be a result of \code{fedstat_get_data_ids} or
\code{fedstat_get_data_ids_special_cases_handle} to download all available data,
or a result of \code{fedstat_data_ids_filter} to download subset of available data}

\item{data_format}{string, one of sdmx, excel}

\item{timeout_seconds}{numeric, maximum time before a new POST request is tried}

\item{retry_max_times}{numeric, maximum number of tries to POST \code{data_ids}}

\item{httr_verbose}{\code{httr::verbose()} or NULL, outputs messages to the console
about the processing of the request}
}
\value{
raw bytes (sdmx or excel)
}
\description{
Creates a request body from \code{data_ids} and sends it to
https://www.fedstat.ru/indicator/data.do?format={\code{data_format}}.
Gets an sdmx or excel with data in binary format.

sdmx raw bytes can be passed to \code{fedstat_parse_sdmx_to_table} to create a
data.frame or to \code{rawToChar} and \code{writeLines} to create an xml file

excel raw bytes can be passed to \code{writeBin} to create an xls file
}
\examples{
\dontrun{
# Get data filters identificators for week prices
# standardize names for DVFO and extract week numbers
# filter the data_ids to get data for week 21 and 22 of 2021
# for all goods and services for Russian Federation
# POST filters and download data in sdmx format
data <- fedstat_get_data_ids("37426") \%>\%
  fedstat_get_data_ids_special_cases_handle(
    filter_value_title_alias_lookup_table = data.frame(
      "filter_value_title" = "Dalnevostochnyj federalnyj okrug ( s 03.11.2018)",
      "filter_value_title_alias" = "Dalnevostochnyj federalnyj okrug"
    )
  ) \%>\%
  fedstat_data_ids_filter(
    filters = list(
      "Territory" = "Russian Federation",
      "Year" = "2021",
      "Period" = c(21, 22),
      "Types of goods and services" = "*"
    )
  ) \%>\%
  fedstat_post_data_ids_filtered()

# In this example names for DVFO are latinized for CRAN
# Not actual filter field titles and filter values titles because of ASCII requirement for CRAN
}
}
\seealso{
\code{\link{fedstat_parse_sdmx_to_table}}
}
