% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feis.R, R/methods.R
\name{feis}
\alias{feis}
\alias{formula.feis}
\alias{terms.feis}
\alias{residuals.feis}
\alias{df.residual.feis}
\alias{coef.feis}
\alias{sigma.feis}
\alias{deviance.feis}
\alias{nobs.feis}
\alias{fitted.feis}
\alias{hatvalues.feis}
\title{Fixed Effects Individual Slope Estimator}
\usage{
feis(
  formula,
  data,
  id,
  robust = FALSE,
  intercept = FALSE,
  dropgroups = FALSE,
  tol = .Machine$double.eps,
  ...
)

\method{formula}{feis}(x, lhs = NULL, rhs = NULL, ...)

\method{terms}{feis}(x, lhs = NULL, rhs = NULL, ...)

\method{residuals}{feis}(object, ...)

\method{df.residual}{feis}(object, ...)

\method{coef}{feis}(object, ...)

\method{sigma}{feis}(object, ...)

\method{deviance}{feis}(object, ...)

\method{nobs}{feis}(object, ...)

\method{fitted}{feis}(object, ...)

\method{hatvalues}{feis}(model, ...)
}
\arguments{
\item{formula}{a symbolic description for the model to be fitted (see Details).}

\item{data}{a \code{data.frame} containing the specified variables.}

\item{id}{the name of a unique group / person identifier (as string).}

\item{robust}{logical. If \code{TRUE} estimates cluster robust standard errors (default is \code{FALSE}).}

\item{intercept}{logical. If \code{TRUE} estimates the model with an intercept (default is \code{FALSE}).}

\item{dropgroups}{logical. If \code{TRUE} groups without any within variance on a slope variable are dropped
, if \code{FALSE} those variables are omitted for the respective groups only (default is \code{FALSE}).}

\item{tol}{the tolerance for detecting linear dependencies in the residual maker transformation
(see \code{\link[base]{solve}}). The argument is forwarded to \code{\link[feisr]{bsfeistest}}.}

\item{...}{further arguments.}

\item{lhs, rhs}{indexes of the left- and right-hand side for the methods formula and terms.}

\item{object, x, model}{an object of class "\code{feis}".}
}
\value{
An object of class "\code{feis}", containing the following elements:
\item{coefficients}{the vector of coefficients.}
\item{vcov}{the scaled (if specified, robust) variance-covariance matrix of the coefficients.
  See \code{\link[feisr]{vcov.feis}} for unscaled vcov}.
\item{residuals}{the vector of residuals (computed from the "detrended" data).}
\item{df.residual}{degrees of freedom of the residuals.}
\item{formula}{an object of class "\code{Formula}" describing the model.}
\item{model}{the original model frame as a \code{data.frame} containing the original
  variables used for estimation.}
\item{modelhat}{a constructed model frame as a \code{data.frame} containing the predicted
  values from the first stage regression using the slope variable(s) as predictor(s).}
\item{modeltrans}{a constructed model frame as a \code{data.frame} containing the "detrended"
  variables used for the final model estimation and the untransformed slope variables.}
\item{response}{the vector of the "detrended" response variable.}
\item{fitted.values}{the vector of fitted values (computed from the "detrended" data).}
\item{id}{a vector containing the unique person identifier.}
\item{call}{the matched call.}
\item{assign}{assign attributes of the formula.}
\item{na.omit}{(where relevant) a vector of the omitted observations. The only handling method
 of \code{NA}s is "\code{omit}".}
\item{contrasts}{(only where relevant) the contrasts used.}
\item{arg}{a list containing the used methods. Only "\code{feis}" and "\code{individual}" effects available.}
\item{slopevars}{a character vector containing the names of the slope variables.}
\item{r2}{R squared of the "detrended" model.}
\item{adj.r2}{adjusted R squared of the "detrended" model.}
\item{vcov_arg}{a character containing the method used to compute the variance-covariance matrix.}
\item{tol}{the tolerance parameter (for use in bsfeistest).}
}
\description{
Estimates fixed effects individual slope estimators by applying linear \code{lm} models
to "detrended" data.
}
\details{
\code{feis} is a special function to estimate linear fixed effects models with individual-specific slopes.
In contrast to conventional fixed effects models, data are not person "demeaned", but "detrended" by
the predicted individual slope of each person
\insertCite{Bruderl.2015.387,Ruttenauer.2020,Wooldridge.2010.384}{feisr}.

Estimation requires at least \code{q+1} observations per unit, where \code{q} is the number of slope
parameters (including a constant).
\code{feis} automatically selects only those groups from the current data set which have at least \code{q+1} observations.
The function returns a warning if units with \code{<q+1} observations are dropped.

The function requires a two-part formula, in which the second part indicates the slope parameter(s).
If, for example, the model is \code{y ~ x1 + x2}, with the slope variables \code{x3} and \code{x4},
the model can be estimated with:
\itemize{
  \item \code{formula = y ~ x1 + x2 | x3 + x4}
}
If the second part is not specified (and individual "slopes" are estimated only by an intercept),
the model reduces to a conventional fixed effects (within) model. In this case please use
the well-established \code{\link[plm]{plm}} (\code{model="within"}) function instead of \code{feis}.

If specified, \code{feis} estimates panel-robust standard errors. Panel-robust standard errors are
robust to arbitrary forms of serial correlation within groups formed by \code{id} as well as
heteroscedasticity across groups \insertCite{@see @Wooldridge.2010.384, pp. 379-381}{feisr}.

The model output can be exported using the \code{\link[texreg]{texreg}} package.
}
\examples{
data("mwp", package = "feisr")
feis.mod <- feis(lnw ~ marry + enrol + as.factor(yeargr) | exp + I(exp^2),
                 data = mwp, id = "id", robust = TRUE)
summary(feis.mod)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[feisr]{summary.feis}}, \code{\link[plm]{plm}}, \code{\link[plm]{pvcm}},
\code{\link[plm]{pmg}}, \code{\link[feisr]{feistest}}
}
