\name{Sensitivity}
\alias{read.sns}
\alias{plot.sns}
\alias{print.sns}

\title{Sensitivity analysis}
\description{
  Using sensitivity analysis in FEMME a .sns file is generated which
  can be read and further processed with these functions
}

\usage{
read.sns(snsfile)

\method{plot}{sns}(x,xvari=1,yvari=2,rev="",type='l',
                     pch=16,main=x$filename,xlab=NULL,ylab=NULL,
                     xlim=NULL,ylim=NULL,\dots)

\method{print}{sns}(x,\dots)


}
\arguments{
  \item{snsfile}{File ending in .sns generated by FEMME}
  \item{x}{object of class sns created by \code{read.sns}}
  \item{xvari}{Index of X Variable}
  \item{yvari}{Index of Y Variable}
  \item{rev}{Reversion of axis}
  \item{type}{Type of plot, default 'line'}
  \item{pch}{Plotting charachter, i.e. symbols}
  \item{main}{Main title}
  \item{xlab}{X axis label}
  \item{ylab}{Y axis label}
  \item{xlim}{Limits of the X axis}
  \item{ylim}{Limits of the Y axis}
  \item{...}{Additional plot parameters}
}
\details{

}
\value{

\code{read.sns} returns a sns object

}
\references{Soetaert et al, 2002, Ecological  Modelling 151: 177-193}

\author{Karline Soetaert <k.soetaert@nioo.knaw.nl}
\note{Use at your own risk}


\examples{

## For examples see: vignette("femmeR")

}

\keyword{file}
\keyword{misc}
\keyword{hplot}

