% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-decomposition.R
\name{data_decomposition}
\alias{data_decomposition}
\title{Decompose Annual Maximum Series}
\usage{
data_decomposition(data, ns_years, ns_structure)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{ns_years}{For NS-FFA only: Numeric vector of observation years corresponding
to \code{data}. Must be the same length as \code{data} and strictly increasing.}

\item{ns_structure}{For NS-FFA only: Named list indicating which distribution
parameters are modeled as nonstationary. Must contain two logical scalars:
\itemize{
\item \code{location}: If \code{TRUE}, the location parameter has a linear temporal trend.
\item \code{scale}: If \code{TRUE}, the scale parameter has a linear temporal trend.
}}
}
\value{
Numeric vector of decomposed data.
}
\description{
Decomposes a nonstationary annual maxima series to derive its stationary stochastic
component, which can be used to identify a best-fit distribution using conventional
stationary methods, like those based on L-moments. The decomposition procedure
follows that proposed by Vidrio-Sahagún and He (2022), which relies on the statistical
representation of nonstationary stochastic processes.
}
\details{
Internally, the function does the following:
\enumerate{
\item If there is a trend in the location, fit Sen's trend estimator and subtract
away the fitted trend.
\item If there is a trend in the scale, estimate the variability of the data
with \code{\link[=data_mw_variability]{data_mw_variability()}}, fit Sen's trend estimator to the variability
vector, and rescale the data to remove the trend.
\item If necessary, shift the data so that its minimum is at least 1.
}
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
ns_years <- seq(from = 1901, to = 2000)
ns_structure <- list(location = TRUE, scale = FALSE)
data_decomposition(data, ns_years, ns_structure)

}
\references{
Vidrio-Sahagún, C. T., and He, J. (2022). The decomposition-based nonstationary
flood frequency analysis. Journal of Hydrology, 612 (September 2022), 128186.
\doi{10.1016/j.jhydrol.2022.128186}
}
\seealso{
\code{\link[=data_mw_variability]{data_mw_variability()}}, \code{\link[=eda_sens_trend]{eda_sens_trend()}}
}
