% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_information.R
\name{kernel_entropy}
\alias{kernel_entropy}
\alias{kernel_entropy.default}
\alias{kernel_entropy.numeric}
\alias{kernel_entropy.matrix}
\alias{kernel_entropy.ts}
\alias{kernel_entropy.xts}
\alias{kernel_entropy.tbl_df}
\alias{kernel_entropy.data.frame}
\title{Partial Information Kernel-Damping}
\usage{
kernel_entropy(x, mean, sigma = NULL)

\method{kernel_entropy}{default}(x, mean, sigma = NULL)

\method{kernel_entropy}{numeric}(x, mean, sigma = NULL)

\method{kernel_entropy}{matrix}(x, mean, sigma = NULL)

\method{kernel_entropy}{ts}(x, mean, sigma = NULL)

\method{kernel_entropy}{xts}(x, mean, sigma = NULL)

\method{kernel_entropy}{tbl_df}(x, mean, sigma = NULL)

\method{kernel_entropy}{data.frame}(x, mean, sigma = NULL)
}
\arguments{
\item{x}{An univariate or a multivariate distribution.}

\item{mean}{A numeric vector in which the kernel should be centered.}

\item{sigma}{The uncertainty (volatility) around the mean. When \code{NULL}, only the mean is constrained.}
}
\value{
A numerical vector of class \code{ffp} with the new
probabilities distribution.
}
\description{
This function uses entropy-pooling to find the probability distribution that can
constrain the first two moments while imposing the minimal structure in the data.
}
\examples{
library(ggplot2)

ret <- diff(log(EuStockMarkets[ , 1]))
mean <- -0.01 # scenarios around -1\%
sigma <- var(diff(ret))

ke <- kernel_entropy(ret, mean, sigma)
ke

autoplot(ke) +
  scale_color_viridis_c()
}
\seealso{
\code{\link{double_decay}}
}
