% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_elev.R
\name{elev}
\alias{elev}
\title{Allow autoplotting the column \code{elev}.}
\usage{
elev(elev)
}
\arguments{
\item{elev}{A ForestGEO-like elevation list or its \code{col} dataframe (with
the column \code{elev}).}
}
\value{
An S3 object of class 'elev'.
}
\description{
Allow autoplotting the column \code{elev}.
}
\examples{
assert_is_installed("fgeo.x")

inherits(elev(fgeo.x::elevation), "elev")
inherits(elev(fgeo.x::elevation$col), "elev")
}
\seealso{
\code{\link[=autoplot.elev]{autoplot.elev()}}.

Other plot functions: 
\code{\link{autoplot.fgeo_habitat}()},
\code{\link{autoplot.sp_elev}()},
\code{\link{autoplot_by_species.sp_elev}()},
\code{\link{plot_dbh_bubbles_by_quadrat}()},
\code{\link{plot_tag_status_by_subquadrat}()},
\code{\link{sp_elev}()},
\code{\link{sp}()}

Other autoplots: 
\code{\link{autoplot.fgeo_habitat}()},
\code{\link{autoplot.sp_elev}()},
\code{\link{sp_elev}()},
\code{\link{sp}()}

Other functions to construct fgeo classes: 
\code{\link{sp_elev}()},
\code{\link{sp}()}

Other functions to plot elevation: 
\code{\link{autoplot.sp_elev}()},
\code{\link{autoplot_by_species.sp_elev}()},
\code{\link{sp_elev}()}
}
\concept{autoplots}
\concept{functions to construct fgeo classes}
\concept{functions to plot elevation}
\concept{plot functions}
