% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhircrack.R
\name{fhir_canonical_design}
\alias{fhir_canonical_design}
\title{Retrieve design of last call to fhir_crack}
\usage{
fhir_canonical_design()
}
\description{
Returns the complete design of the last call to \code{\link{fhir_crack}} with
automatically amended elements, i.e. the canonical form of the design with elements resource, cols, style
and respective sub-elements.
}
\examples{
#load example bundles
bundles <- fhir_unserialize(patient_bundles)

#incomplete but valid design
design <- list(
  Pat = list(
    resource = "//Patient"
    )
)

result <- fhir_crack(bundles, design)

fhir_canonical_design()

}
