% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhir_bundle_list.R
\name{fhir_bundle_list}
\alias{fhir_bundle_list}
\title{Create \linkS4class{fhir_bundle_list} object}
\usage{
fhir_bundle_list(bundles)
}
\arguments{
\item{bundles}{A list of xml_nodes/fhir_bundle_xml objects or of raw/fhir_bundle_serialized objects}
}
\description{
A fhir_bundle_list is a list of fhir_bundle_xml or fhir_bundle_serialized objects. It is
usually returned by a call to \code{\link[=fhir_search]{fhir_search()}}.
}
\details{
The only scenario where one would use this constructor function is when several \linkS4class{fhir_bundle}
or \linkS4class{fhir_bundle_list} objects should be merged into one big \linkS4class{fhir_bundle_list} before cracking (see examples).
}
\examples{

#unserialize example bundles
bundles1 <- fhir_unserialize(example_bundles1)
bundles2 <- fhir_unserialize(example_bundles2)

#bind them together in one fhir_bundle_list
bound_bundles <- fhir_bundle_list(c(bundles1, bundles2))
class(bound_bundles)

#bound list contains bundles from both original lists
length(bundles1)
length(bundles2)
length(bound_bundles)



#Create fhir_bundle list from xml objects
b1 <- xml2::read_xml("<Bundle><Resource><item value='1'/></Resource></Bundle>")
b2 <- xml2::read_xml("<Bundle><Resource><item value='2'/></Resource></Bundle>")

fhir_bundle_list(bundles = list(b1, b2))
fhir_bundle_list(bundles = list(fhir_bundle_xml(b1), fhir_bundle_xml(b2)))

r1 <- xml2::xml_serialize(object = b1, connection= NULL)
r2 <- xml2::xml_serialize(object = b2, connection= NULL)

fhir_bundle_list(bundles = list(r1, r2))
}
