% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_tag.R
\name{fig_tag}
\alias{fig_tag}
\title{Add tags and a caption to a fig.}
\usage{
fig_tag(
  plot,
  tag,
  pos = "topleft",
  x_nudge = 0,
  y_nudge = 0,
  colour = NULL,
  alpha = NULL,
  hjust = NULL,
  vjust = NULL,
  fontsize = 12,
  fontface = NULL,
  fontfamily = NULL
)
}
\arguments{
\item{plot}{Plot from img2plot function.}

\item{tag}{Label to add to plot.}

\item{pos}{Position of label (Default 'topleft').}

\item{x_nudge}{Minor adjustments to the x position in relative plot
coordindates (0 being furthest left, 1 being furthest right).}

\item{y_nudge}{Minor adjustments to the y position in relative plot
coordinates (0 being the bottom, 1 being the top).}

\item{colour}{Colour of label text.}

\item{alpha}{Alpha of label text.}

\item{hjust}{hjust of plot label.}

\item{vjust}{vjust of plot label.}

\item{fontsize}{Fontsize of label (in points).}

\item{fontface}{The font face (bolt, italic, ...)}

\item{fontfamily}{Fontfamily of plot label.}
}
\value{
\code{\{ggplot2\} object}
}
\description{
Add tags and a caption to a fig.
}
\examples{

library(figpatch)
library(ggplot2)

# Attach the fig image file
image <- system.file("extdata", "fig.png",
  package = "figpatch", mustWork =
    TRUE
)

# Read in the image as a 'fig'
img <- fig(image)

# Add tags on top of the figs
img1 <- fig_tag(img, "A")
img2 <- fig_tag(img, "B", pos = "topright")

# assemble the patchwork
patchwork::wrap_plots(img1, img2)
}
