% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{RenameWithNums}
\alias{RenameWithNums}
\title{Replace file names with numbers.}
\usage{
RenameWithNums(dir = ".", pattern = NULL)
}
\arguments{
\item{dir}{The directory in which to rename the files (relative or absolute
path). Defaults to current working directory.}

\item{pattern}{A regular expression. If specified, only files with names
matching this pattern will be treated.}
}
\value{
A logical vector with a \code{TRUE} for each successful renaming.
}
\description{
Rename the files in the directory, replacing file names with numbers only.
}
\examples{
setwd(tempdir())
dir.create("RenameWithNums_test")
setwd("RenameWithNums_test")
files <- c("1litres 1.txt", "1litres 30.txt", "3litres 5.txt")
file.create(files)
RenameWithNums()
list.files()
setwd("..")
RemoveDirs("RenameWithNums_test")
}
