% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4h_second_filter_ats.R
\name{second_filter_ats_4h}
\alias{second_filter_ats_4h}
\title{Four Hit Filter for ATS Detections}
\usage{
second_filter_ats_4h(fish_file)
}
\arguments{
\item{fish_file}{a dataframe of detections retrieved from add_fish()}
}
\value{
A dataframe which has been filtered to remove false positives
}
\description{
This function takes an ATS detection dataframe generated from the
add_fish() function and filters it a second time to remove any remaining
multipath detections, and then check the remaining detections by comparing the time
between detections, for a rolling window of 4 detections to ensure it is less
16.6x the stated pulse rate interval. It additionally checks that all
detections within the window occur within 20\% of the pulse rate interval of
the other detections and that the standard deviation of pulse rate intervals
is less than 0.025. It additionally checks that all detections have a frequency
between 416.3 and 418.75 kHz and that the frequency of all detections are within
0.505kHz of each other. Called by second_filter().
}
\examples{
# Apply a four-hit ATS filter to a prefiltered dataset with fish and tag
# attributes
second_filter_ats_4h(filter_fish_detects)
# No detections are valid
}
