% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/second_filter_ats.R
\name{second_filter_ats}
\alias{second_filter_ats}
\title{Two Hit Filter for ATS Detections}
\usage{
second_filter_ats(fish_file)
}
\arguments{
\item{fish_file}{a dataframe of detections retrieved from add_fish()}
}
\value{
A dataframe which has been filtered to remove false positives
}
\description{
This function takes an ATS detection dataframe generated from the
add_fish() function and filters it a second time to remove any remaining
multipath detections, and then check the remaining detections by comparing
the time between each detection to ensure it is less 4x the stated pulse rate
interval. It additionally checks that all detections have a frequency
between 416.3 and 418.75 kHz and that the frequency of all detections are within
0.505kHz of each other. Called by second_filter_2h4h().
}
\examples{
# Apply the ATS filter to a prefiltered dataset with fish and tag
# attributes
second_filter_ats(filter_fish_detects)
}
