% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_column_totals.R
\name{ff_column_totals}
\alias{ff_column_totals}
\alias{finalfit_column_totals}
\title{Add column totals to \code{summary_factorlist()} output}
\usage{
ff_column_totals(
  df.in,
  .data,
  dependent,
  na_include_dependent = FALSE,
  percent = TRUE,
  digits = c(1, 0),
  label = NULL,
  prefix = "",
  weights = NULL
)

finalfit_column_totals(
  df.in,
  .data,
  dependent,
  na_include_dependent = FALSE,
  percent = TRUE,
  digits = c(1, 0),
  label = NULL,
  prefix = "",
  weights = NULL
)
}
\arguments{
\item{df.in}{\code{summary_factorlist()} output.}

\item{.data}{Data frame used to create \code{summary_factorlist()}.}

\item{dependent}{Character. Name of dependent variable.}

\item{na_include_dependent}{Logical. When TRUE, missing data in the dependent
variable is included in totals.}

\item{percent}{Logical. Include percentage.}

\item{digits}{Integer length 2. Number of digits for (1) percentage, (2) weighted count.}

\item{label}{Character. Label for total row.}

\item{prefix}{Character. Prefix for column totals, e.g "N=".}

\item{weights}{Character vector of length 1: name of column to use for weights.}
}
\value{
Data frame.
}
\description{
Add column totals to \code{summary_factorlist()} output
}
\examples{
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = 'mort_5yr'
colon_s \%>\%
 summary_factorlist(dependent, explanatory) \%>\%
 ff_column_totals(colon_s, dependent)

# Ensure works with missing data in dependent
colon_s = colon_s \%>\%
 dplyr::mutate(
  mort_5yr = forcats::fct_explicit_na(mort_5yr)
 )
 colon_s \%>\%
 summary_factorlist(dependent, explanatory) \%>\%
 ff_column_totals(colon_s, dependent)
}
