# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Iterative solver for final size.
#'
#' @param contact_matrix Social contact matrix. Entry \eqn{mm_{ij}} gives
#' average number of contacts in group \eqn{i} reported by participants in
#' group \eqn{j}.
#' @param demography_vector Demography vector. Entry \eqn{pp_{i}} gives
#' proportion of total population in group \eqn{i}
#' (model will normalise if needed).
#' @param susceptibility A matrix giving the susceptibility of individuals in
#' demographic group \eqn{i} and risk group \eqn{j}.
#' @param iterations Number of solver iterations. Defaults to 10,000.
#' @param tolerance Solver error tolerance. Solving for final size ends when
#' the error drops below this tolerance. Defaults to set `1e-6`.
#' Larger tolerance values are likely to lead to inaccurate final size
#' estimates.
#' @param step_rate The solver step rate. Defaults to 1.9 as a value found to
#' work well.
#' @param adapt_step Boolean, whether the solver step rate should be changed
#' based on the solver error. Defaults to TRUE.
#' @keywords internal
#'
#' @return A vector of final sizes, of the size (N demography groups *
#' N risk groups).
.solve_iterative <- function(contact_matrix, demography_vector, susceptibility, iterations = 10000L, tolerance = 1e-6, step_rate = 1.9, adapt_step = TRUE) {
    .Call('_finalsize_solve_final_size_iterative', PACKAGE = 'finalsize', contact_matrix, demography_vector, susceptibility, iterations, tolerance, step_rate, adapt_step)
}

#' @title Newton solver for final size.
#'
#' @param contact_matrix Social contact matrix. Entry \eqn{mm_{ij}} gives
#' average number of contacts in group \eqn{i} reported by participants in
#' group \eqn{j}.
#' @param demography_vector Demography vector. Entry \eqn{pp_{i}} gives
#' proportion of total population in group \eqn{i}
#' (model will normalise if needed).
#' @param susceptibility A matrix giving the susceptibility of individuals in
#' demographic group \eqn{i} and risk group \eqn{j}.
#' @param iterations Number of solver iterations. Defaults to 10,000.
#' @param tolerance Solver error tolerance. Solving for final size ends when
#' the error drops below this tolerance. Defaults to set `1e-6`.
#' Larger tolerance values are likely to lead to inaccurate final size
#' estimates.
#' @keywords internal
#'
#' @return A two dimensional array of final sizes per age-risk group.
.solve_newton <- function(contact_matrix, demography_vector, susceptibility, iterations = 10000L, tolerance = 1e-6) {
    .Call('_finalsize_solve_final_size_newton', PACKAGE = 'finalsize', contact_matrix, demography_vector, susceptibility, iterations, tolerance)
}

