% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{bilateral_trade_FI_to_RUS}
\alias{bilateral_trade_FI_to_RUS}
\title{Bilateral trade between Finland and Russia}
\usage{
bilateral_trade_FI_to_RUS(start_time = NA, end_time = NA, user_key = NA)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains bilateral trade between Finland
and Russia. Fingrid and the Russian parties confirm the bilateral
trades on 400 kV cross-border connection in the morning of the
commercial day D for the following commercial day D+1. The confirmed
bilateral trades will be bid price-independently on the electricity
spot market
}
\description{
Check https://data.fingrid.fi/en/dataset/bilateral-trade-between-finland-and-russia
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- bilateral_trade_FI_to_RUS(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
