% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_data_exploration.R
\name{fst_freq_table}
\alias{fst_freq_table}
\title{Make Top Words Table}
\usage{
fst_freq_table(
  data,
  number = 10,
  norm = NULL,
  pos_filter = NULL,
  strict = TRUE,
  use_svydesign_weights = FALSE,
  id = "",
  svydesign = NULL,
  use_column_weights = FALSE
)
}
\arguments{
\item{data}{A dataframe of text in CoNLL-U format, with optional additional
columns.}

\item{number}{The number of top words to return, default is `10`.}

\item{norm}{The method for normalising the data. Valid settings are
`"number_words"` (the number of words in the responses), `"number_resp"`
(the number of responses), or `NULL` (raw count returned, default, also used
when weights are applied).}

\item{pos_filter}{List of UPOS tags for inclusion, default is `NULL` which
means all word types included.}

\item{strict}{Whether to strictly cut-off at `number` (ties are
alphabetically ordered), default is `TRUE`.}

\item{use_svydesign_weights}{Option to weight words in the table using
weights from  a `svydesign` containing the raw data, default is `FALSE`}

\item{id}{ID column from raw data, required if `use_svydesign_weights = TRUE`
and must match the `docid` in formatted `data`.}

\item{svydesign}{A `svydesign` which contains the raw data and weights,
required if `use_svydesign_weights = TRUE`.}

\item{use_column_weights}{Option to weight words in the table using
weights from  formatted data which includes addition `weight` column,
default is `FALSE`}
}
\value{
A table of the most frequently occurring words in the data.
}
\description{
Creates a table of the most frequently-occurring words (unigrams) within the
data. Optionally, weights can be provided either through a `weight` column in
the formatted data, or from a `svydesign` object with the raw (preformatted)
data.
}
\examples{
pf <- c("NOUN", "VERB", "ADJ", "ADV")
pf2 <- "NOUN, VERB, ADJ, ADV"
fst_freq_table(fst_child, number = 15, strict = FALSE, pos_filter = pf)
fst_freq_table(fst_child, number = 15, strict = FALSE, pos_filter = pf2)
fst_freq_table(fst_child, norm = 'number_words')
fst_freq_table(fst_child, use_column_weights = TRUE)
c2 <- fst_child_2
s <- survey::svydesign(id=~1, weights= ~paino, data = child)
i <- 'fsd_id'
fst_freq_table(c2, use_svydesign_weights = TRUE, svydesign = s, id = i)
}
