% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_data_exploration.R
\name{fst_wordcloud}
\alias{fst_wordcloud}
\title{Make Wordcloud}
\usage{
fst_wordcloud(
  data,
  pos_filter = NULL,
  max = 100,
  use_svydesign_weights = FALSE,
  id = "",
  svydesign = NULL,
  use_column_weights = FALSE
)
}
\arguments{
\item{data}{A dataframe of text in CoNLL-U format, with optional additional
columns.}

\item{pos_filter}{List of UPOS tags for inclusion, default is `NULL` which
means all word types included.}

\item{max}{The maximum number of words to display, default is `100`.}

\item{use_svydesign_weights}{Option to weight words in the wordcloud using
weights from a `svydesign` containing the raw data, default is `FALSE`}

\item{id}{ID column from raw data, required if `use_svydesign_weights = TRUE`
and must match the `docid` in formatted `data`.}

\item{svydesign}{A `svydesign` which contains the raw data and weights,
required if `use_svydesign_weights = TRUE`.}

\item{use_column_weights}{Option to weight words in the wordcloud using
weights from  formatted data which includes addition `weight` column,
default is `FALSE`.}
}
\value{
A wordcloud from the data.
}
\description{
Creates a wordcloud from CoNLL-U data of frequently-occurring words.
Optionally, weights can be provided either through a `weight` column in the
formatted data, or from a `svydesign` object with the raw (preformatted)
data.
}
\examples{
fst_wordcloud(fst_child)
fst_wordcloud(fst_child, pos_filter = c("NOUN", "VERB", "ADJ", "ADV"))
fst_wordcloud(fst_child, pos_filter = 'NOUN, VERB, ADJ')
fst_wordcloud(fst_child, use_column_weights = TRUE)
i <- 'fsd_id'
c <- fst_child_2
s <- survey::svydesign(id=~1, weights= ~paino, data = child)
fst_wordcloud(c, use_svydesign_weights = TRUE, id = i, svydesign = s)
}
