% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top.percent.by.R
\name{top.percent.by}
\alias{top.percent.by}
\title{Subset the top percent of a dataframe by a specific column}
\usage{
top.percent.by(df, percentage, by)
}
\arguments{
\item{df}{A dataframe object as returned by passing the result of `bait.gfw.effort()` to `fish()`.}

\item{percentage}{Number. The 'x' in 'the top x percent of the dataframe'.}

\item{by}{Character. The name of the column for which the percentage will be calculated.}
}
\value{
A dataframe.
}
\description{
Function that sorts a dataframe in descending order for a specific column, calculates the sum of all rows for that column, applies the chosen percentage to said sum, and subsets the minimum number of consecutive rows needed to reach this value.
}
\examples{
\donttest{
bait <- bait.gfw.effort(table = "fishing_effort_byvessel_v2", end_date="2012-01-02")

catch <- fish(bait = bait)

who.fishs.the.most <- top.percent.by(catch, 90, "fishing_hours")
}

}
\seealso{
[bait.gfw.effort()] [fish()]
}
