% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMPBin.R
\name{pCOMPBin}
\alias{pCOMPBin}
\title{COM Poisson Binomial Distribution}
\usage{
pCOMPBin(x,n,p,v)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{n}{single value for no of binomial trials.}

\item{p}{single value for probability of success.}

\item{v}{single value for  v.}
}
\value{
The output of \code{pCOMPBin} gives  cumulative probability  values in vector form.
}
\description{
These functions provide the ability for generating probability function values and
cumulative probability function values for the COM Poisson  Binomial Distribution.
}
\details{
The probability function and cumulative function can be constructed and are denoted below

The cumulative probability function is the summation of probability function values.

\deqn{P_{COMPBin}(x) = \frac{{n \choose x}^v p^x (1-p)^{n-x}}{\sum_{j=0}^{n} {n \choose j}^v p^j (1-p)^{(n-j)}}}
\deqn{x = 0,1,2,3,...n}
\deqn{n = 1,2,3,...}
\deqn{0 < p < 1}
\deqn{-\infty < v < +\infty }

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
#plotting the random variables and probability values
col <- rainbow(5)
a <- c(0.58,0.59,0.6,0.61,0.62)
b <- c(0.022,0.023,0.024,0.025,0.026)
plot(0,0,main="COM Poisson Binomial probability function graph",xlab="Binomial random variable",
ylab="Probability function values",xlim = c(0,10),ylim = c(0,0.5))
for (i in 1:5)
{
lines(0:10,dCOMPBin(0:10,10,a[i],b[i])$pdf,col = col[i],lwd=2.85)
points(0:10,dCOMPBin(0:10,10,a[i],b[i])$pdf,col = col[i],pch=16)
}

dCOMPBin(0:10,10,0.58,0.022)$pdf      #extracting the pdf values
dCOMPBin(0:10,10,0.58,0.022)$mean     #extracting the mean
dCOMPBin(0:10,10,0.58,0.022)$var      #extracting the variance

#plotting the random variables and cumulative probability values
col <- rainbow(5)
a <- c(0.58,0.59,0.6,0.61,0.62)
b <- c(0.022,0.023,0.024,0.025,0.026)
plot(0,0,main="COM Poisson Binomial probability function graph",xlab="Binomial random variable",
ylab="Probability function values",xlim = c(0,10),ylim = c(0,1))
for (i in 1:5)
{
lines(0:10,pCOMPBin(0:10,10,a[i],b[i]),col = col[i],lwd=2.85)
points(0:10,pCOMPBin(0:10,10,a[i],b[i]),col = col[i],pch=16)
}

pCOMPBin(0:10,10,0.58,0.022)      #acquiring the cumulative probability values

}
\references{
Extracted from

Borges, P., Rodrigues, J., Balakrishnan, N. and Bazan, J., 2014. A COM-Poisson type
generalization of the binomial distribution and its properties and applications.
Statistics & Probability Letters, 87, pp.158-166.

Available at: \doi{10.1016/j.spl.2014.01.019}
}
