% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fit_univariate_man}
\alias{fit_univariate_man}
\title{Fit Univariate Distributions by Specifying Parameters}
\usage{
fit_univariate_man(family, parameters)
}
\arguments{
\item{family}{distribution family character name}

\item{parameters}{named vector of parameters to set}
}
\value{
list of family functions for d, p, q, r, and parameters
}
\description{
Fit Univariate Distributions by Specifying Parameters
}
\examples{
manFun <- fit_univariate_man('norm', c(mean = 2, sd = 5))
set.seed(5)
m1 <- mean(manFun$rnorm(100000))
set.seed(5)
m2 <- mean(rnorm(100000, 2, 5))
identical(m1, m2)
}
