% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{resid.fixest}
\alias{resid.fixest}
\alias{residuals.fixest}
\title{Extracts residuals from a \code{fixest} object}
\usage{
\method{resid}{fixest}(object, ...)

\method{residuals}{fixest}(object, ...)
}
\arguments{
\item{object}{A \code{fixest} object. Obtained using the functions \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}.}

\item{...}{Not currently used.}
}
\value{
It returns a numeric vector of the length the number of observations used for the estimation.
}
\description{
This function extracts residuals from a fitted model estimated with \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}.
}
\details{
The residuals returned are the difference between the dependent variable and the expected predictor.
}
\examples{

# simple estimation on iris data, clustering by "Species"
res_poisson = femlm(Sepal.Length ~ Sepal.Width + Petal.Length +
                    Petal.Width | Species, iris)

# we plot the residuals
plot(resid(res_poisson))

}
\seealso{
See also the main estimation functions \code{\link[fixest]{femlm}}, \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}}. \code{\link[fixest]{fitted.fixest}}, \code{\link[fixest]{predict.fixest}}, \code{\link[fixest]{summary.fixest}}, \code{\link[fixest]{vcov.fixest}}, \code{\link[fixest]{fixef.fixest}}.
}
\author{
Laurent Berge
}
