% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest.R
\docType{package}
\name{fixest-package}
\alias{fixest}
\alias{fixest-package}
\title{Fast and User-Friendly Fixed-Effects Estimations}
\description{
The package \pkg{fixest} provides a family of functions to perform estimations with multiple fixed-effects. Standard-errors can be easily and intuitively clustered. It also includes tools to seamlessly export the results of various estimations.
}
\details{
This package efficiently estimates models with multiple fixed-effect (i.e. multiple large factor variables).

The core functions are: \code{\link[fixest]{feols}}, \code{\link[fixest]{feglm}} and \code{\link[fixest]{femlm}} to estimate, respectively, linear models, generalized linear models and maximum likelihood models with multiple fixed-effects. The function \code{\link[fixest]{feNmlm}} allows the inclusion of non-linear in parameters right hand sides. Finally \code{\link[fixest]{fepois}} and \code{\link[fixest]{fenegbin}} are shorthands to estimate Poisson and Negative Binomial models.

Note that the functions \code{\link[fixest]{feglm}} and \code{\link[fixest]{femlm}} provide the same results when using the same families but differ in that the latter is a direct maximum likelihood optimization (so the two can really have different convergence rates).

Several features are also included such as the possibility to easily compute different types of standard-errors (including multi-way clustering).

It is possible to compare the results of several estimations by using the function \code{\link[fixest]{etable}}, which also allows to export them to Latex.

You can plot the coefficients and confidence intervals of estimations easily with the function \code{\link[fixest]{coefplot}}. This function also offers a specific layout for interactions.
}
\references{
Berg\\'e, Laurent, 2018, "Efficient estimation of maximum likelihood models with multiple fixed-effects: the R package FENmlm." CREA Discussion Papers, 13 (\url{https://wwwen.uni.lu/content/download/110162/1299525/file/2018_13}).
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/lrberge/fixest/issues}
}

}
\author{
\strong{Maintainer}: Laurent Berge \email{laurent.berge@uni.lu}

}
