% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_special_characters_in_data.R
\name{fix_special_characters_in_data}
\alias{fix_special_characters_in_data}
\title{Remove Non-Alphanumeric Characters from Data Frame}
\usage{
fix_special_characters_in_data(df)
}
\arguments{
\item{df}{A data frame.}
}
\value{
A modified data frame where all non-numeric columns have had non-alphanumeric characters removed.
}
\description{
This function removes non-alphanumeric characters from all non-numeric columns in a data frame. The columns are modified in-place.
}
\examples{
df <- data.frame(a = c("A*B", "C&D"), b = c("1.2", "3.4"))
fix_special_characters_in_data(df)
# Output:
#   a    b
# 1 AB  1.2
# 2 CD  3.4

}
