% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMixHMM.R
\docType{class}
\name{ModelMixHMM-class}
\alias{ModelMixHMM-class}
\alias{ModelMixHMM}
\title{A Reference Class which represents a fitted Mixture of HMM model.}
\description{
ModelMixHMM represents an estimated mixture of HMM model.
}
\section{Fields}{

\describe{
\item{\code{param}}{A \link{ParamMixHMM} object. It contains the estimated
values of the parameters.}

\item{\code{stat}}{A \link{StatMixHMM} object. It contains all the statistics
associated to the MixHMM model.}
}}

\section{Methods}{

\describe{
\item{\code{plot(what = c("clustered", "smoothed", "loglikelihood"), ...)}}{Plot method
\describe{
  \item{\code{what}}{The type of graph requested:
    \itemize{
      \item \code{"clustered" = } Clustered curves (field
        \code{klas} of class \link{StatMixHMM}).
      \item \code{"smoothed" = } Smoothed signal (field
        \code{smoothed} of class {StatMixHMM}).
      \item \code{"loglikelihood" = } Value of the log-likelihood for
        each iteration (field \code{stored_loglik} of class
        \link{StatMixHMM}).
    }
  }
  \item{\code{\dots}}{Other graphics parameters.}
}}

\item{\code{summary(digits = getOption("digits"))}}{Summary method.
\describe{
  \item{\code{digits}}{The number of significant digits to use when
    printing.}
}}
}}

\examples{
data(toydataset)
Y <- t(toydataset[,2:ncol(toydataset)])

mixhmm <- emMixHMM(Y = Y, K = 3, R = 3, verbose = TRUE)

# mixhmm is a ModelMixHMM object. It contains some methods such as 'summary' and 'plot'
mixhmm$summary()
mixhmm$plot()

# mixhmm has also two fields, stat and param which are reference classes as well

# Log-likelihood:
mixhmm$stat$loglik

# Means
mixhmm$param$mu
}
\seealso{
\link{ParamMixHMM}, \link{StatMixHMM}
}
