% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamMixHMMR.R
\docType{class}
\name{ParamMixHMMR-class}
\alias{ParamMixHMMR-class}
\alias{ParamMixHMMR}
\title{A Reference Class which contains parameters of a mixture of HMMR models.}
\description{
ParamMixHMMR contains all the parameters of a mixture of HMMR models.
}
\section{Fields}{

\describe{
\item{\code{fData}}{\link{FData} object representing the sample (covariates/inputs
\code{X} and observed responses/outputs \code{Y}).}

\item{\code{K}}{The number of clusters (Number of HMMR models).}

\item{\code{R}}{The number of regimes (HMMR components) for each cluster.}

\item{\code{p}}{The order of the polynomial regression.}

\item{\code{variance_type}}{Character indicating if the model is homoskedastic
(\code{variance_type = "homoskedastic"}) or heteroskedastic (\code{variance_type = "heteroskedastic"}). By default the model is heteroskedastic.}

\item{\code{order_constraint}}{A logical indicating whether or not a mask of order
one should be applied to the transition matrix of the Markov chain to
provide ordered states. For the purpose of segmentation, it must be set to
\code{TRUE} (which is the default value).}

\item{\code{alpha}}{Cluster weights. Matrix of dimension \eqn{(K, 1)}.}

\item{\code{prior}}{The prior probabilities of the Markov chains. \code{prior} is a
matrix of dimension \eqn{(R, K)}. The k-th column represents the prior
distribution of the Markov chain asociated to the cluster k.}

\item{\code{trans_mat}}{The transition matrices of the Markov chains. \code{trans_mat} is
an array of dimension \eqn{(R, R, K)}.}

\item{\code{mask}}{Mask applied to the transition matrices \code{trans_mat}. By default,
a mask of order one is applied.}

\item{\code{beta}}{Parameters of the polynomial regressions. \code{beta} is an array of
dimension \eqn{(p + 1, R, K)}, with \code{p} the order of the polynomial
regression. \code{p} is fixed to 3 by default.}

\item{\code{sigma2}}{The variances for the \code{K} clusters. If MixHMMR model is
heteroskedastic (\code{variance_type = "heteroskedastic"}) then \code{sigma2} is a
matrix of size \eqn{(R, K)} (otherwise MixHMMR model is homoskedastic
(\code{variance_type = "homoskedastic"}) and \code{sigma2} is a matrix of size}

\item{\code{nu}}{The degree of freedom of the MixHMMR model representing the
complexity of the model.}

\item{\code{phi}}{A list giving the regression design matrix for the polynomial regressions.}
}}

\section{Methods}{

\describe{
\item{\code{initParam(init_kmeans = TRUE, try_algo = 1)}}{Method to initialize parameters \code{alpha}, \code{prior},
      \code{trans_mat}, \code{beta} and \code{sigma2}.

      If \code{init_kmeans = TRUE} then the curve partition is initialized by
      the K-means algorithm. Otherwise the curve partition is initialized
      randomly.

      If \code{try_algo = 1} then \code{beta} and \code{sigma2} are
      initialized by segmenting  the time series \code{Y} uniformly into
      \code{R} contiguous segments. Otherwise, \code{beta} and
      \code{sigma2} are initialized by segmenting randomly the time series
      \code{Y} into \code{R} segments.}

\item{\code{initRegressionParam(Y, k, R, phi, variance_type, try_algo)}}{Initialize \code{beta} and \code{sigma2} for the cluster \code{k}.}

\item{\code{MStep(statMixHMMR)}}{Method which implements the M-step of the EM algorithm to learn the
parameters of the MixHMMR model based on statistics provided by the
object \code{statMixHMMR} of class \link{StatMixHMMR} (which contains
the E-step).}
}}

