% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_identical.R
\name{all_identical}
\alias{all_identical}
\title{all_identical}
\usage{
all_identical(x, fun, ...)
}
\arguments{
\item{x}{A nested list of objects.}

\item{fun}{Function used to extract information of each element of \code{x}.}

\item{...}{Further arguments passed to \code{fun}.}
}
\value{
A logical vector of length one.
}
\description{
Checks if an aspect is identical for all elements in a nested list. The aspect is specified by \code{fun}, e.g. \code{[[}, followed by the element name to compare.
}
\examples{
x <- list(a = 1, b = 2)
y <- list(a = 1, b = 3)
all_identical(list(x, y), `[[`, "a")
all_identical(list(x, y), `[[`, "b")
}
