% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table_extract_labels.R
\name{extract_labels}
\alias{extract_labels}
\alias{extract_labels.pivot_table}
\title{Extract labels}
\usage{
extract_labels(pt, col = 1, labels = c())

\method{extract_labels}{pivot_table}(pt, col = 1, labels = c())
}
\arguments{
\item{pt}{A \code{pivot_table} object.}

\item{col}{A number, column from which labels are extracted.}

\item{labels}{A vector of strings, set of labels to extract.}
}
\value{
A \code{pivot_table} object.
}
\description{
Extract the given set of labels from a table column in compact format to
generate a new column in the table.
}
\details{
Sometimes a table column includes values of multiple label fields, this is
generally known as compact table format. Given a column number and a set of
labels, it generates a new column with the labels located at the positions
they occupied in the original column and removes them from it.
}
\examples{
library(tidyr)

pt <- pt_m4_compact \%>\%
  extract_labels(col = 1, labels = c("b1", "b2", "b3", "b4", "Total general"))

pt <- pt_ine2871 \%>\%
  extract_labels(col = 1, labels = c("18 Granada"))

}
\seealso{


Other pivot table transformation functions: 
\code{\link{fill_labels}()},
\code{\link{fill_values}()},
\code{\link{get_col_values}()},
\code{\link{remove_agg}()},
\code{\link{remove_k}()},
\code{\link{replace_dec}()}
}
\concept{pivot table transformation functions}
