% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-tag-version.R
\name{tag_version}
\alias{tag_version}
\title{Create a new version tag}
\usage{
tag_version(force = FALSE)
}
\arguments{
\item{force}{Re-tag even if the last commit wasn't created by
\code{\link[=bump_version]{bump_version()}}.  Useful when defining a CRAN release.}
}
\value{
The created tag, invisibly.

None
}
\description{
Parses \code{NEWS.md} and creates/updates the tag for the most recent version.
}
\examples{
# Create mock package in a temporary directory.
# Set open to TRUE if you want to play in the mock package.
with_demo_project({
  # Use functions as if inside the newly created package project.
  # (Or go and actually run code inside the newly created package project!)
  # Add a new R file.
  usethis::use_r("cool-function", open = FALSE)
  # Pretend we added useful code inside it.
  # Track the new R file with Git.
  gert::git_add("R/cool-function.R")
  gert::git_commit("- Add cool function.")
  # Bump version with fledge.
  fledge::bump_version()
  fledge::update_news(c("- something I forgot", "- blabla"))
  fledge::update_version()
  gert::git_add("NEWS.md")
  gert::git_commit(message = "release notes tweaking")
  fledge::tag_version()
  print(fledge::get_last_tag())
})
}
