## ----echo = FALSE--------------------------------------------------------
knitr::opts_chunk$set(
  message = FALSE,
  collapse = TRUE,
  comment = "#>"
)

## ----warning=FALSE, message=FALSE----------------------------------------
library(flextable)
library(officer)
library(magrittr)

## ----warning=FALSE, message=FALSE----------------------------------------
select_columns <- c("Species", "Petal.Length", "Petal.Width")
myft <- regulartable(iris[46:55,], col_keys = select_columns) %>% 
  merge_v(~ Species + Petal.Width )

tabwid(myft) 

## ----warning=FALSE, message=FALSE----------------------------------------
select_columns <- c("Species", "Petal.Length", "Petal.Width")
myft <- regulartable(head(mtcars, n = 10 ) ) %>% 
  merge_h( ) %>%
  border(border = fp_border(), part = "all") # and add borders

tabwid(myft)

## ----warning=FALSE, message=FALSE----------------------------------------
select_columns <- c("Species", "Petal.Length", "Petal.Width")
myft <- regulartable(head(mtcars, n = 6 ) ) %>% 
  merge_at( i = 1:3, j = 1:3) %>%
  border(border = fp_border(), part = "all") # and add borders

tabwid(myft)

## ------------------------------------------------------------------------
tabwid(myft %>% merge_none())

## ------------------------------------------------------------------------
data <- iris[c(1:3, 51:53, 101:104),]

regulartable(data, col_keys = c("Species", "Sepal.Length", "Petal.Length") ) %>%
  theme_booktabs() %>% 
  tabwid()


## ------------------------------------------------------------------------
regulartable(data = data, col_keys = c("Species", "col_1", "Sepal.Length", "Petal.Length") ) %>%
  theme_vanilla() %>% autofit() %>% 
  border(j=2, border = fp_border(width=0), part = "all") %>% 
  tabwid()


## ----warning=FALSE, message=FALSE----------------------------------------
ft <- regulartable( head( iris ) ) %>% 
  set_header_labels(Sepal.Length = "Sepal", 
    Sepal.Width = "Sepal", Petal.Length = "Petal",
    Petal.Width = "Petal", Species = "Species" )
  
ft %>% theme_vanilla() %>% autofit() %>% tabwid()

## ----warning=FALSE, message=FALSE----------------------------------------
ft <- ft %>% 
  add_header(Sepal.Length = "length",
    Sepal.Width = "width", Petal.Length = "length",
    Petal.Width = "width", Species = "Species", top = FALSE ) 
ft %>% theme_vanilla() %>% autofit() %>% tabwid()
ft <- ft %>% 
  add_header(Sepal.Length = "Inches",
    Sepal.Width = "Inches", Petal.Length = "Inches",
    Petal.Width = "Inches", Species = "Species", top = TRUE )

# merge identical cells
ft <- ft %>% merge_h(part = "header") %>% merge_v(part = "header")

ft %>% theme_vanilla() %>% autofit() %>% tabwid()

## ----warning=FALSE, message=FALSE----------------------------------------
typology <- data.frame(
  col_keys = c( "Sepal.Length", "Sepal.Width", "Petal.Length",
                "Petal.Width", "Species" ),
  type = c("double", "double", "double", "double", "factor"),
  what = c("Sepal", "Sepal", "Petal", "Petal", "Species"),
  measure = c("Length", "Width", "Length", "Width", "Species"),
  stringsAsFactors = FALSE )
typology %>% flextable() %>% theme_vanilla() %>% autofit() %>% tabwid()

## ----warning=FALSE, message=FALSE----------------------------------------
regulartable( head( iris ) ) %>% 
  set_header_df( mapping = typology, key = "col_keys" ) %>% 
  merge_h(part = "header") %>% merge_v(part = "header") %>% 
  theme_vanilla() %>% autofit() %>% tabwid()

## ------------------------------------------------------------------------
ft_base <- regulartable(head(iris)) %>% 
  theme_tron_legacy()
tabwid(ft_base)
dim(ft_base)

## ------------------------------------------------------------------------
dim_pretty(ft_base)

## ------------------------------------------------------------------------
ft <- ft_base %>% 
  autofit(add_w = 0, add_h = 0)

dim(ft)
tabwid(ft)

## ------------------------------------------------------------------------
ft <- ft_base %>% autofit() %>% 
  width(j = ~ Species, width = 2) %>% 
  height( height = .4, part = "all" )
tabwid(ft)

