% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{colformat_num}
\alias{colformat_num}
\title{format numeric cells}
\usage{
colformat_num(
  x,
  i = NULL,
  j = NULL,
  big.mark = get_flextable_defaults()$big.mark,
  decimal.mark = get_flextable_defaults()$decimal.mark,
  na_str = get_flextable_defaults()$na_str,
  nan_str = get_flextable_defaults()$nan_str,
  prefix = "",
  suffix = "",
  ...
)
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection.}

\item{big.mark, decimal.mark}{see \code{\link[=format]{format()}}}

\item{na_str}{string to be used for NA and NaN values}

\item{nan_str}{string to be used for NA and NaN values}

\item{prefix}{string to be used as prefix or suffix}

\item{suffix}{string to be used as prefix or suffix}

\item{...}{additional argument for function \code{\link[=format]{format()}}, \code{scientific}
and \code{digits} can not be used.}
}
\description{
Format numeric cells in a flextable.

The function is different from \code{\link[=colformat_double]{colformat_double()}} on numeric type
columns. The function uses the \code{\link[=format]{format()}} function of R on numeric
type columns. So this is normally what you see on the R console
most of the time (but scientific mode is disabled, NA are replaced, etc.).
}
\section{format call}{


Function \code{\link[=format]{format()}} is called with the following values:
\itemize{
\item \code{trim} is set to TRUE,
\item \code{scientific} is set to FALSE,
\item \code{big.mark} is set to the value of \code{big.mark} argument,
\item \code{decimal.mark} is set to the value of \code{decimal.mark} argument,
\item other arguments are passed 'as is' to the format function.
}

argument \code{digits} is ignored as it is not the same \code{digits} that users
want, this one will be used by \code{\link[=format]{format()}} and not \code{\link[=formatC]{formatC()}}.
To change the digit argument use \code{options(digits=4)} instead.

This argument will not be changed because \code{colformat_num()}
is supposed to format things roughly as what you see on the R console.

If you are not happy with these choices, use \code{\link[=set_formatter]{set_formatter()}}
and define your own format.
}

\section{Illustrations}{


\if{html}{\figure{fig_colformat_num_1.png}{options: width="400"}}
}

\examples{
dat <- mtcars
dat[2,1] <- NA
ft <- flextable(head(dat))
ft <- colformat_num(x = ft,
  big.mark=" ", decimal.mark = ",",
  na_str = "N/A")
ft <- autofit(ft)
ft
}
\seealso{
Other cells formatters: 
\code{\link{colformat_char}()},
\code{\link{colformat_datetime}()},
\code{\link{colformat_date}()},
\code{\link{colformat_double}()},
\code{\link{colformat_image}()},
\code{\link{colformat_int}()},
\code{\link{colformat_lgl}()},
\code{\link{compose}()},
\code{\link{set_formatter}()}
}
\concept{cells formatters}
