% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{download_flightsbr_file}
\alias{download_flightsbr_file}
\title{Download file from url}
\usage{
download_flightsbr_file(
  file_url = parent.frame()$file_url,
  showProgress = parent.frame()$showProgress,
  dest_file = temp_local_file
)
}
\arguments{
\item{file_url}{String. A url passed from \code{\link{get_flights_url}}.}

\item{showProgress}{Logical, passed from \code{\link{read_flights}}}

\item{dest_file}{String, passed from \code{\link{read_flights}}}
}
\value{
Silently saves downloaded file to temp dir.
}
\description{
Download file from url
}
\examples{
\dontrun{ if (interactive()) {
# Generate url
file_url <- get_flights_url(type='basica', year=2000, month=11)

# download data
download_flightsbr_file(file_url=file_url,
                        showProgress=TRUE,
                        dest_file = tempfile(fileext = ".zip")
                       )
}}
}
\keyword{internal}
