% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two-sample-test.R
\name{two_sample_test}
\alias{two_sample_test}
\title{Two-Sample Permutation Test}
\usage{
two_sample_test(
  x,
  y,
  statistic = stat_hotelling,
  B = 1000L,
  test = "exact",
  combining_function = "tippett",
  seed = NULL
)
}
\arguments{
\item{x}{A list or matrix representing the 1st sample.}

\item{y}{A list or matrix representing the 2nd sample.}

\item{statistic}{A character vector specifying the chosen test statistic(s).
These can be \code{\link{stat_hotelling}} or user-specified functions that
define desired statistics. See the section \emph{User-supplied statistic
function} for more information on how these user-supplied functions should
be structured for compatibility with the \strong{flipr} framwork. Default is
\code{\link{stat_hotelling}}.}

\item{B}{The number of sampled permutation. Default is \code{1000L}.}

\item{test}{A string specifying if performing an exact test through the use
of Phipson-Smyth estimate of the p-value or an approximate test through a
Monte-Carlo estimate of the p-value. Default is \code{"exact"}.}

\item{combining_function}{A string specifying the combining function to be
used to compute the single test statistic value from the set of p-value
estimates obtained during the non-parametric combination testing procedure.
Default is \code{"tippett"}, which picks Tippett's function.}

\item{seed}{An integer specifying the seed of the random generator useful for
result reproducibility or method comparisons. Default is \code{NULL}.}
}
\value{
A \code{\link[base]{list}} with three components: the value of the
statistic for the original two samples, the p-value of the resulting
permutation test and a numeric vector storing the values of the permuted
statistics.
}
\description{
This function carries out an hypothesis test where the null hypothesis is
that the two samples are ruled by the same underlying generative probability
distribution against the alternative hypothesis that they are ruled by two
separate generative probability distributions.
}
\section{User-supplied statistic function}{

A user-specified function should have at least two arguments:
\itemize{
\item the first argument is \code{data} which should be a list of the \code{n1 + n2}
concatenated observations with the original \code{n1} observations from the first
sample on top and the original \code{n2} observations from the second sample
below;
\item the second argument is \code{indices} which should be an integer vector giving
the indices in \code{data} that are considered to belong to the first sample.
}

See the \code{\link{stat_hotelling}} function for an example.
}

\examples{
n <- 10L
mx <- 0
sigma <- 1

# Two different models for the two populations
x <- rnorm(n = n, mean = mx, sd = sigma)
delta <- 10
my <- mx + delta
y <- rnorm(n = n, mean = my, sd = sigma)
t1 <- two_sample_test(x, y)
t1$pvalue

# Same model for the two populations
x <- rnorm(n = n, mean = mx, sd = sigma)
delta <- 0
my <- mx + delta
y <- rnorm(n = n, mean = my, sd = sigma)
t2 <- two_sample_test(x, y)
t2$pvalue
}
