% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fc_draw.R
\name{fc_draw}
\alias{fc_draw}
\title{fc_draw}
\usage{
fc_draw(
  object,
  big.mark = "",
  box_corners = "round",
  arrow_angle = 30,
  arrow_length = grid::unit(0.1, "inches"),
  arrow_ends = "last",
  arrow_type = "closed",
  arrow_color = "black",
  arrow_fill = "black",
  arrow_lwd = 1,
  arrow_lineend = "round",
  arrow_linejoin = "round",
  title = NULL,
  title_x = 0.5,
  title_y = 0.9,
  title_color = "black",
  title_fs = 15,
  title_fface = 2,
  title_ffamily = NULL,
  canvas_bg = "white"
)
}
\arguments{
\item{object}{fc object that we want to draw.}

\item{big.mark}{character. Used to specify the thousands separator for patient count values. Defaults is no separator (\code{""}); if not empty used as mark between every 3 digits (ex: \code{big.mark = ","} results in \verb{1,000} instead of \code{1000}).}

\item{box_corners}{Indicator of whether to draw boxes with round (\code{"round"}) vs non-round (\code{"sharp"}) corners. Default is \code{"round"}.}

\item{arrow_angle}{The angle of the arrow head in degrees, as in \code{arrow}.}

\item{arrow_length}{A unit specifying the length of the arrow head (from tip to base), as in \code{arrow}.}

\item{arrow_ends}{One of \code{"last"}, \code{"first"}, or \code{"both"}, indicating which ends of the line to draw arrow heads, as in \link{arrow}.}

\item{arrow_type}{One of \code{"open"} or \code{"closed"} indicating whether the arrow head should be a closed triangle, as in \link{arrow}.}

\item{arrow_color}{Color of the arrows. Default is \code{"black"}. See the \code{col} parameter for \link{gpar}.}

\item{arrow_fill}{Color for filling the arrow head. Default is \code{"black"}. See the \code{fill} parameter for \link{gpar}.}

\item{arrow_lwd}{Line width of the arrows. Default is 1. See the \code{lwd} parameter for \link{gpar}.}

\item{arrow_lineend}{Line end style for arrows. One of \code{"round"}, \code{"butt"}, or \code{"square"}. Default is \code{"round"}. See the \code{lineend} parameter for \link{gpar}.}

\item{arrow_linejoin}{Line join style for arrow heads (i.e., shape of arrow head corners). One of \code{"round"}, \code{"mitre"}, or \code{"bevel"}. Default is \code{"round"}. See the \code{linejoin} parameter for \link{gpar}.}

\item{title}{The title of the flowchart. Default is \code{NULL} (no title).}

\item{title_x}{x coordinate for the title. Default is 0.5.}

\item{title_y}{y coordinate for the title. Default is 0.9.}

\item{title_color}{Color of the title. It is \code{"black"} by default. See the \code{col} parameter for \link{gpar}.}

\item{title_fs}{Font size of the title. It is 15 by default. See the \code{fontsize} parameter for \link{gpar}.}

\item{title_fface}{Font face of the title. It is 2 by default. See the \code{fontface} parameter for \link{gpar}.}

\item{title_ffamily}{Changes the font family of the title. Default is \code{NA}. See the \code{fontfamily} parameter for \link{gpar}.}

\item{canvas_bg}{Background color for the entire canvas (the area behind the flowchart boxes). Default is \code{"white"}. Set to \code{"transparent"} or \code{NULL} for a transparent background; \code{"transparent"} background will only be noticeable when exporting drawn flowcharts via \code{\link[=fc_export]{fc_export()}} and is compatible with all \code{\link[=fc_export]{fc_export()}} formats except \code{"jpeg"} and \code{"bmp"}.}
}
\value{
Invisibly returns the same object that has been given to the function, with the given arguments to draw the flowchart stored in the attributes.
}
\description{
This function allows to draw the flowchart from a fc object.
}
\examples{
safo |>
  as_fc(label = "Patients assessed for eligibility") |>
  fc_filter(!is.na(group), label = "Randomized", show_exc = TRUE) |>
  fc_split(group) |>
  fc_filter(itt == "Yes", label = "Included in ITT") |>
  fc_filter(pp == "Yes", label = "Included in PP") |>
  fc_draw()

}
