% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_flow}
\alias{plot_flow}
\alias{plot_flow.character}
\alias{plot_flow.flow}
\alias{plot_flow.flowdef}
\alias{plot_flow.list}
\title{plot_flow}
\usage{
plot_flow(x, ...)

\method{plot_flow}{flow}(x, ...)

\method{plot_flow}{list}(x, ...)

\method{plot_flow}{character}(x, ...)

\method{plot_flow}{flowdef}(x, detailed = TRUE, type = c("1", "2"),
  pdf = FALSE, pdffile, ...)
}
\arguments{
\item{x}{Object of class \code{flow}, or a list of flow objects or a flowdef}

\item{...}{experimental}

\item{detailed}{include some details}

\item{type}{1 is original, and 2 is a elipse with less details}

\item{pdf}{create a pdf instead of plotting interactively}

\item{pdffile}{output file name for the pdf file}
}
\description{
plot the flow object

plot_flow.character: works on a flowdef file.
}
\examples{
qobj = queue(type="lsf")
cmds = rep("sleep 5", 10)
jobj1 <- job(q_obj=qobj, cmd = cmds, submission_type = "scatter", name = "job1")
jobj2 <- job(q_obj=qobj, name = "job2", cmd = cmds, submission_type = "scatter",
             dependency_type = "serial", previous_job = "job1")
fobj <- flow(jobs = list(jobj1, jobj2))
plot_flow(fobj)

### Gather: many to one relationship
jobj1 <- job(q_obj=qobj, cmd = cmds, submission_type = "scatter", name = "job1")
jobj2 <- job(q_obj=qobj, name = "job2", cmd = cmds, submission_type = "scatter",
             dependency_type = "gather", previous_job = "job1")
fobj <- flow(jobs = list(jobj1, jobj2))
plot_flow(fobj)

### Burst: one to many relationship
jobj1 <- job(q_obj=qobj, cmd = cmds, submission_type = "serial", name = "job1")
jobj2 <- job(q_obj=qobj, name = "job2", cmd = cmds, submission_type = "scatter",
             dependency_type = "burst", previous_job = "job1")
fobj <- flow(jobs = list(jobj1, jobj2))
plot_flow(fobj)
}

