% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midi.R
\name{midi_play}
\alias{midi_play}
\alias{midi_convert}
\alias{midi_read}
\alias{demo_midi}
\title{Play or convert a midi file}
\usage{
midi_play(
  midi = demo_midi(),
  soundfont = soundfont_path(),
  audio.driver = NULL,
  settings = list(),
  verbose = interactive()
)

midi_convert(
  midi = demo_midi(),
  soundfont = soundfont_path(),
  output = "output.mp3",
  settings = list(),
  verbose = interactive()
)

midi_read(midi = demo_midi(), verbose = FALSE)

demo_midi()
}
\arguments{
\item{midi}{path to the midi file}

\item{soundfont}{path to the soundfont}

\item{audio.driver}{which audio driver to use,
see \href{https://www.fluidsynth.org/api/CreatingAudioDriver.html}{fluidsynth docs}}

\item{settings}{a named vector with additional settings from \code{\link[=fluidsynth_setting_list]{fluidsynth_setting_list()}}}

\item{verbose}{print some progress status to the terminal}

\item{output}{filename of the output. The out}
}
\value{
midi_read returns data frame with midi events.
}
\description{
Play a midi file to your audio device, render it to a file, or parse the raw data.
Additional settings can be specified, see \link{fluidsynth_setting_list} for available
options.
}
\details{
The \code{midi_convert} function internally uses fluidsynth to generate a raw wav file,
and then \code{\link[av:encoding]{av::av_audio_convert()}} to convert into the requested about format. See
\code{\link[av:formats]{av::av_muxers()}} for supported output formats and their corresponding file extension.

You need a soundfont to synthesize midi, see the \link{soundfonts} page. On Linux you may
also need to specify an \code{audio.driver} that works for your hardware, although on
recent distributions the defaults generally work.
}
\examples{
df <- midi_read(demo_midi())
}
\seealso{
Other fluidsynth: 
\code{\link{fluidsynth_settings}},
\code{\link{soundfonts}}
}
\concept{fluidsynth}
