% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_plot.R
\name{flux_plot}
\alias{flux_plot}
\title{Plotting fluxes for visual evaluation}
\usage{
flux_plot(
  slopes_df,
  f_conc = f_conc,
  f_datetime = f_datetime,
  color_discard = "#D55E00",
  color_cut = "#D55E00",
  color_ok = "#009E73",
  color_zero = "#CC79A7",
  scale_x_datetime_args = list(date_breaks = "1 min", minor_breaks = "10 sec",
    date_labels = "\%e/\%m \\n \%H:\%M"),
  f_ylim_upper = 800,
  f_ylim_lower = 400,
  f_plotname = "",
  facet_wrap_args = list(ncol = 4, nrow = 3, scales = "free"),
  y_text_position = 500,
  print_plot = "FALSE",
  output = "print_only",
  ggsave_args = list()
)
}
\arguments{
\item{slopes_df}{dataset containing slopes,
with flags produced by \link[fluxible:flux_quality]{flux_quality}}

\item{f_conc}{column with gas concentration}

\item{f_datetime}{column with datetime of each data point}

\item{color_discard}{color for fits with a discard quality flag}

\item{color_cut}{color for the part of the flux that is cut}

\item{color_ok}{color for fits with an ok quality flag}

\item{color_zero}{color for fits with a zero quality flag}

\item{scale_x_datetime_args}{list of arguments for
\link[ggplot2:scale_x_datetime]{scale_x_datetime}}

\item{f_ylim_upper}{y axis upper limit}

\item{f_ylim_lower}{y axis lower limit}

\item{f_plotname}{filename for the extracted pdf file;
if empty, the name of \code{slopes_df} will be used}

\item{facet_wrap_args}{list of arguments for
\link[ggforce:facet_wrap_paginate]{facet_wrap_paginate}}

\item{y_text_position}{position of the text box}

\item{print_plot}{logical, if TRUE it prints the plot as a ggplot object
but will take time depending on the size of the dataset}

\item{output}{\code{pdfpages}, the plots are saved as A4 landscape pdf pages;
\code{ggsave}, the plots can be saved with the ggsave function;
\code{print_only} (default) prints the plot without creating a file
(independently from \code{print_plot} being TRUE or FALSE)}

\item{ggsave_args}{list of arguments for \link[ggplot2:ggsave]{ggsave}
(in case \code{output = "ggsave"})}
}
\value{
plots of fluxes, with raw concentration data points, fit, slope,
and color code indicating quality flags and cuts. The plots are organized
in facets according to flux ID, and a text box display the quality flag and
diagnostics of each measurement.
The plots are returned as a ggplot object if \code{print_plot = TRUE};
if \code{print_plot = FALSE} it will not return anything but will produce a file
according to the \code{output} argument.
}
\description{
Plots the fluxes, fit and slope in facets
with color code indicating quality flags
This function takes time to run and is optional in the workflow,
but it is still highly recommended to use it to visually check
the measurements. Note that 'flux_plot' is specific to the
\link[fluxible]{fluxible} package and
will work best with datasets produced following a fluxible workflow.
}
\examples{
data(co2_conc)
slopes <- flux_fitting(co2_conc, conc, datetime, fit_type = "exp_zhao18")
slopes_flag <- flux_quality(slopes, conc)
flux_plot(slopes_flag, conc, datetime)
}
