% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_files.R
\name{list_files}
\alias{list_files}
\title{List the Files in a Directory/Folder}
\usage{
list_files(path = "", pattern = NULL, recursive = FALSE,
  ignore.case = FALSE, full.names = TRUE,
  data_source = flyio_get_datasource(),
  bucket = flyio_get_bucket(data_source), check_region = FALSE)
}
\arguments{
\item{path}{the folder for which the files need to be listed}

\item{pattern}{an optional regular expression. Only file path names that match the regular expression will be returned.}

\item{recursive}{logical. Should the listing recurse into directories?}

\item{ignore.case}{logical. Should pattern-matching be case-insensitive?}

\item{full.names}{logical. Should the entire path be returned or only after the path inputed?}

\item{data_source}{the name of the data source, gcs, s3 or local; if not set globally}

\item{bucket}{the name of the bucket, if not set globally}

\item{check_region}{logical. to check region for aws.s3}
}
\value{
a vector of full file names
}
\description{
list the files in cloud or locally - similar to list.files()
}
\examples{
# List files locally
list_files(path = tempdir(), data_source = "local")
\dontrun{
# List files on S3
flyio_set_datasource("s3")
flyio_set_bucket("your-bucket-name")
list_files(path = "tests/", pattern = ".*csv")
}
}
