% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interest-rate-classes.R
\name{as_DiscountFactor}
\alias{as_DiscountFactor}
\alias{as_DiscountFactor.InterestRate}
\title{Coerce to DiscountFactor}
\usage{
as_DiscountFactor(x, ...)

\method{as_DiscountFactor}{InterestRate}(x, d1, d2, ...)
}
\arguments{
\item{x}{object to coerce}

\item{...}{other parameters passed to methods}

\item{d1}{a \code{Date} vector containing the as of date}

\item{d2}{a \code{Date} vector containing the date to which the discount factor
applies}
}
\value{
a \code{DiscountFactor} object
}
\description{
You can coerce objects to the \code{DiscountFactor} class using this method.
}
\examples{
library("lubridate")
as_DiscountFactor(InterestRate(c(0.04, 0.05), c(2, 4), 'act/365'),
  ymd(20140101), ymd(20150101))
}
