% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/money-class.R
\name{MultiCurrencyMoney}
\alias{MultiCurrencyMoney}
\title{MultiCurrencyMoney}
\usage{
MultiCurrencyMoney(monies)
}
\arguments{
\item{monies}{a list of \link[=SingleCurrencyMoney]{SingleCurrencyMoney}}
}
\value{
a \code{MultiCurrencyMoney} object that extends \code{\link[tibble:tibble]{tibble::tibble()}}
}
\description{
This class associates a vector of numeric values with a list of currencies.
This can be useful for example to store value of cash flows. Internally it
represents this information as an extension to a \link[tibble:tibble]{tibble}.
You are able to bind \code{MultiCurrencyMoney} objects by using \code{\link[=rbind]{rbind()}} (see
example below).
}
\examples{
mcm <- MultiCurrencyMoney(list(
  SingleCurrencyMoney(1, AUD()),
  SingleCurrencyMoney(2, USD())
))
rbind(mcm, mcm)
}
\seealso{
Other money functions: \code{\link{CashFlow}},
  \code{\link{SingleCurrencyMoney}},
  \code{\link{is.CashFlow}},
  \code{\link{is.MultiCurrencyMoney}},
  \code{\link{is.SingleCurrencyMoney}}
}
