% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluator.R
\name{fm_evaluate}
\alias{fm_evaluate}
\alias{fm_evaluate.default}
\alias{fm_evaluate.fm_evaluator}
\alias{fm_evaluator}
\alias{fm_evaluator.fm_mesh_2d}
\alias{fm_evaluator.fm_mesh_1d}
\alias{fm_evaluator.fm_tensor}
\alias{fm_evaluator_lattice}
\alias{fm_evaluator.inla.mesh}
\alias{fm_evaluator.inla.mesh.1d}
\title{Methods for projecting to/from mesh objects}
\usage{
fm_evaluate(...)

\method{fm_evaluate}{default}(mesh, field, ...)

\method{fm_evaluate}{fm_evaluator}(projector, field, ...)

fm_evaluator(...)

\method{fm_evaluator}{fm_mesh_2d}(mesh, loc = NULL, lattice = NULL, crs = NULL, ...)

\method{fm_evaluator}{fm_mesh_1d}(mesh, loc = NULL, xlim = mesh$interval, dims = 100, ...)

\method{fm_evaluator}{fm_tensor}(x, loc, ...)

fm_evaluator_lattice(
  mesh,
  xlim = NULL,
  ylim = NULL,
  dims = c(100, 100),
  projection = NULL,
  crs = NULL,
  ...
)

\method{fm_evaluator}{inla.mesh}(mesh, loc = NULL, lattice = NULL, crs = NULL, ...)

\method{fm_evaluator}{inla.mesh.1d}(mesh, loc = NULL, xlim = mesh$interval, dims = 100, ...)
}
\arguments{
\item{\dots}{Additional arguments passed on to methods.}

\item{mesh}{An \code{inla.mesh} or \code{inla.mesh.1d} object.}

\item{field}{Basis function weights, one per mesh basis function, describing
the function to be evaluated at the projection locations}

\item{projector}{An \code{fm_evaluator} object.}

\item{loc}{Projection locations.  Can be a matrix, \code{SpatialPoints},
\code{SpatialPointsDataFrame}, \code{sf}, \code{sfc}, or \code{sfg} object.}

\item{lattice}{An \code{\link[=fm_lattice_2d]{fm_lattice_2d()}} object.}

\item{crs}{An optional CRS or inla.CRS object associated with \code{loc}
and/or \code{lattice}.}

\item{xlim}{X-axis limits for a lattice. For R2 meshes, defaults to covering
the domain.}

\item{dims}{Lattice dimensions.}

\item{x}{\code{\link[=fm_tensor]{fm_tensor()}} object}

\item{ylim}{Y-axis limits for a lattice. For R2 meshes, defaults to covering
the domain.}

\item{projection}{One of \code{c("default", "longlat", "longsinlat", "mollweide")}.}
}
\value{
A vector or matrix of the evaluated function

An \code{fm_evaluator} object
}
\description{
Calculate evaluation information and/or evaluate a function
defined on a mesh or function space.
}
\section{Methods (by class)}{
\itemize{
\item \code{fm_evaluate(default)}: The default method calls
\code{proj = fm_evaluator(mesh, ...)}, followed by \code{fm_evaluate(proj, field)}.

}}
\section{Functions}{
\itemize{
\item \code{fm_evaluate()}: Returns the field function evaluated at the locations determined by an
\code{fm_evaluator} object. \code{fm_evaluate(mesh, field = field, ...)} is a
shortcut to \code{fm_evaluate(fm_evaluator(mesh, ...), field = field)}.

\item \code{fm_evaluator()}: Returns an \code{fm_evaluator} list object with evaluation information.
The \code{proj} element contains a mapping matrix \code{A} and a logical vector \code{ok},
that indicates which locations were mappable to the input mesh.
For \code{fm_mesh_2d} and \code{inla.mesh}
input, \code{proj} also contains a matrix \code{bary} and vector \code{t}, with the
barycentric coordinates within the triangle each input location falls in.

\item \code{fm_evaluator(fm_mesh_2d)}: The \code{...} arguments are passed on to \code{fm_evaluator_lattice()}
if no \code{loc} or \code{lattice} is provided.

\item \code{fm_evaluator_lattice()}: Creates an \code{\link[=fm_lattice_2d]{fm_lattice_2d()}} object, by default covering the input mesh.

\item \code{fm_evaluator(inla.mesh)}: The \code{...} arguments are passed on to \code{fm_evaluator_lattice()}
if no \code{loc} or \code{lattice} is provided.

}}
\examples{
if (TRUE) {
  n <- 20
  loc <- matrix(runif(n * 2), n, 2)
  mesh <- fm_rcdt_2d_inla(loc, refine = list(max.edge = 0.05))
  proj <- fm_evaluator(mesh)
  field <- cos(mesh$loc[, 1] * 2 * pi * 3) * sin(mesh$loc[, 2] * 2 * pi * 7)
  image(proj$x, proj$y, fm_evaluate(proj, field))
}
\donttest{
# if (require("ggplot2") &&
#  require("ggpolypath")) {
#  ggplot() +
#    gg(data = fm_as_sfc(mesh), col = field)
# }
}

}
\seealso{
\code{\link[=fm_mesh_2d]{fm_mesh_2d()}}, \code{\link[=fm_mesh_1d]{fm_mesh_1d()}},
\code{\link[=fm_lattice_2d]{fm_lattice_2d()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
