% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluator.R
\name{fm_raw_basis}
\alias{fm_raw_basis}
\title{Basis functions for mesh manifolds}
\usage{
fm_raw_basis(
  mesh,
  type = "b.spline",
  n = 3,
  degree = 2,
  knot.placement = "uniform.area",
  rot.inv = TRUE,
  boundary = "free",
  free.clamped = TRUE,
  ...
)
}
\arguments{
\item{mesh}{An \code{\link[=fm_mesh_1d]{fm_mesh_1d()}} or \code{\link[=fm_mesh_2d]{fm_mesh_2d()}} object.}

\item{type}{\code{b.spline} (default) for B-spline basis functions,
\code{sph.harm} for spherical harmonics (available only for meshes on the
sphere)}

\item{n}{For B-splines, the number of basis functions in each direction (for
1d meshes \code{n} must be a scalar, and for planar 2d meshes a 2-vector).
For spherical harmonics, \code{n} is the maximal harmonic order.}

\item{degree}{Degree of B-spline polynomials.  See
\code{\link[=fm_mesh_1d]{fm_mesh_1d()}}.}

\item{knot.placement}{For B-splines on the sphere, controls the latitudinal
placements of knots. \code{"uniform.area"} (default) gives uniform spacing
in \code{sin(latitude)}, \code{"uniform.latitude"} gives uniform spacing in
latitudes.}

\item{rot.inv}{For spherical harmonics on a sphere, \code{rot.inv=TRUE}
gives the rotationally invariant subset of basis functions.}

\item{boundary}{Boundary specification, default is free boundaries.  See
\code{\link[=fm_mesh_1d]{fm_mesh_1d()}} for more information.}

\item{free.clamped}{If \code{TRUE} and \code{boundary} is \code{"free"}, the
boundary basis functions are clamped to 0/1 at the interval boundary by
repeating the boundary knots. See
\code{\link[=fm_mesh_1d]{fm_mesh_1d()}} for more information.}

\item{...}{Unused}
}
\value{
A matrix with evaluated basis function
}
\description{
Calculate basis functions on \code{\link[=fm_mesh_1d]{fm_mesh_1d()}} or \code{\link[=fm_mesh_2d]{fm_mesh_2d()}},
without necessarily matching the default function space of the given mesh
object.
}
\examples{

loc <- rbind(c(0, 0), c(1, 0), c(1, 1), c(0, 1))
mesh <- fm_mesh_2d(loc, max.edge = 0.15)
basis <- fm_raw_basis(mesh, n = c(4, 5))

proj <- fm_evaluator(mesh, dims = c(10, 10))
image(proj$x, proj$y, fm_evaluate(proj, basis[, 7]), asp = 1)
\donttest{
if (interactive() && require("rgl")) {
  plot_rgl(mesh, col = basis[, 7], draw.edges = FALSE, draw.vertices = FALSE)
}
}

}
\seealso{
\code{\link[=fm_mesh_1d]{fm_mesh_1d()}}, \code{\link[=fm_mesh_2d]{fm_mesh_2d()}}, \code{\link[=fm_basis]{fm_basis()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
