% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flist.R
\name{write.flist}
\alias{write.flist}
\title{Write a formatting list to the file system}
\usage{
write.flist(x, dir_path = getwd(), file_name = NULL)
}
\arguments{
\item{x}{The formatting list to write.}

\item{dir_path}{The directory path to write the catalog to. Default is the 
current working directory.}

\item{file_name}{The name of the file to save the catalog as.  Default is
the name of the variable that contains the formatting list.  The ".flist" file
extension will be added automatically.}
}
\value{
The full path of the saved formatting list.
}
\description{
The \code{write.flist} function writes a formatting list
to the file system.  By default, the formatting list will be written to the 
current working directory, using the variable name as the file name.  These
defaults can be overridden using the appropriate parameters.  The catalog
will be saved with a file extension of ".flist".
}
\examples{
# Create formatting list
fl <- flist(f1 = "\%5.1f",
            f2 = "\%6.2f",
            type = "row")
           
# Get temp directory
tmp <- tempdir()            
           
# Save formatting list to file system
pth <- write.flist(fl, dir_path = tmp)

# Read from file system
fr <- read.flist(pth)

# Create sample data
dat <- c(12.3844, 292.28432)

# Use formats in the catalog
fapply(dat, fr)
# [1] " 12.4"  "292.28"

}
\seealso{
Other flist: 
\code{\link{as.data.frame.fmt_lst}()},
\code{\link{as.flist}()},
\code{\link{as.flist.data.frame}()},
\code{\link{as.flist.fcat}()},
\code{\link{as.flist.list}()},
\code{\link{as.flist.tbl_df}()},
\code{\link{flist}()},
\code{\link{is.flist}()},
\code{\link{print.fmt_lst}()},
\code{\link{read.flist}()}
}
\concept{flist}
