% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran_details.R
\name{cran_details}
\alias{cran_details}
\alias{summary.cran_details}
\alias{summary_cran_details}
\title{Get details about the CRAN check results for packages}
\usage{
cran_details(pkg, src = c("website", "crandb"), ...)

\method{summary}{cran_details}(object, show_log = TRUE, print_ok = TRUE, ...)

summary_cran_details(
  pkg,
  src = c("website", "crandb"),
  show_log = TRUE,
  print_ok = TRUE,
  ...
)
}
\arguments{
\item{pkg}{character vector of the names for the packages on CRAN}

\item{src}{if \code{"website"} the data is scrapped from the CRAN
website, if \code{"crandb"} the data is downloaded from a RDS
file hosted on the CRAN servers (which is used to generate the
information found on the CRAN website).}

\item{...}{additional arguments to control where the data from the
check results are coming from and how they are downloaded from
the CRAN servers (see Details section).}

\item{object}{an object created by \code{cran_details}}

\item{show_log}{Should the messages of the \dQuote{Check Details}
be printed? (logical)}

\item{print_ok}{if \code{TRUE} the summary method will print a "all clear"
message for package(s) that have an OK status for all CRAN checks.}
}
\value{
a \code{tibble} listing the names of the packages that have non- OK
check results, the nature of the result (\code{WARN}, \code{ERROR},
\code{FAIL}, \code{NOTE}, or other issues).
}
\description{
Given the names of packages published on CRAN, return the output of
checks that return notes, warnings or errors.
}
\details{
Where does the data come from?

The data comes from the CRAN servers. They generate RDS files that
contains information regarding the results of the checks for all
the packages, and all the flavors. This data is then used to
generate the web pages.

\code{foghorn} provides access to either of these data sources. If
you choose \code{src = "website"} the data is scrapped from the
CRAN website. If you only need to check a few packages, this is a
good option. If you choose \code{src = "crandb"} the RDS files
(about 20Mb) are downloaded first from the CRAN servers.

When choosing \code{src = "crandb"} you can also specify the
following options:
\itemize{
\item \code{dest}:  a folder where to store the RDS files (\code{tempdir()}
by default).
\item \code{protocol}: either \code{https} or \code{http}.
\item \code{overwrite}: when \code{FALSE} (default), if the file exists in
\code{dest} then it will not be downloaded again. When
\code{TRUE} the file gets downloaded every time it's
needed.
}
}
\seealso{
Note that the \code{tools} package contains unexported
functions that can be used to extract summary information from
the check results. Specifically
\code{tools:::sumarize_CRAN_check_status} is similar to
\code{show_cran_results}.
}
