% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotopes.R
\docType{data}
\name{law2006}
\alias{law2006}
\title{Law Dome Ice Core}
\format{
A \code{data.frame} with 2004 observations and 8 variables:
\describe{
\item{year}{\code{\link{integer}}: year AD.}
\item{NOAA04}{\code{\link{numeric}}: NOAA04 \eqn{CH_4}{CH4} scale.}
\item{CH4_spl}{\code{\link{numeric}}: \eqn{CH_4}{CH4} spline (ppb).}
\item{CH4_grw}{\code{\link{numeric}}: \eqn{CH_4}{CH4} growth Rate (ppb/yr).}
\item{CO2_spl}{\code{\link{numeric}}: \eqn{CO_2}{CO2} spline (ppb).}
\item{CO2_grw}{\code{\link{numeric}}: \eqn{CO_2}{CO2} growth Rate (ppb/yr).}
\item{N2O_spl}{\code{\link{numeric}}: \eqn{N_{2}O}{N2O} spline (ppb).}
\item{N2O_grw}{\code{\link{numeric}}: \eqn{N_{2}O}{N2O} growth Rate (ppb/yr).}
}
}
\source{
\url{https://www.ncei.noaa.gov/access/paleo-search/study/9959}
}
\usage{
law2006
}
\description{
Law Dome Ice Core 2000-year \eqn{CH_4}{CH4}, \eqn{CO_2}{CO2} and
\eqn{N_{2}O}{N2O} data.
}
\examples{
plot(
  x = law2006$year,
  y = law2006$CO2_spl,
  type = "l",
  xlab = "Year AD",
  ylab = expression("CO"[2]~"(ppm)")
)
}
\references{
MacFarling Meure, C., Etheridge, D., Trudinger, C., Steele, P., Langenfelds,
R., van Ommen, T., Smith, A. and Elkins, J. (2006). The Law Dome CO2, CH4
and N2O Ice Core Records Extended to 2000 years BP. \emph{Geophysical
Research Letters}, 33(14), L14810. \doi{10.1029/2006GL026152}.
}
\seealso{
Other palaeoenvironment data: 
\code{\link{epica2008}},
\code{\link{lisiecki2005}},
\code{\link{ngrip2004}},
\code{\link{ngrip2010}},
\code{\link{spratt2016}}
}
\concept{palaeoenvironment data}
\keyword{datasets}
