% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foot_prob.R
\name{foot_prob}
\alias{foot_prob}
\title{Plot football matches probabilities for out-of-sample football matches.}
\usage{
foot_prob(object, data, home_team, away_team)
}
\arguments{
\item{object}{An object either of class \code{\link[rstan]{stanfit}} as given by \code{stan_foot} function or
\code{\link{list}} as given by \code{mle_foot}.}

\item{data}{A data frame, or a matrix containing the following mandatory items: home team, away team,
home goals, away goals.}

\item{home_team}{The home team(s) for the predicted matches.}

\item{away_team}{The away team(s) for the predicted matches.}
}
\value{
A \code{\link{data.frame}} containing the number of out-of-sample matches specified through the
argument \code{predict}  passed either in the \code{mle_foot} or in the \code{stan_foot} function.
For Bayesian Poisson models the function returns also the most likely outcome (mlo) and a posterior
probability plot for the exact results.
}
\description{
The function provides a table containing the home win, draw and away win probabilities for a bunch of
out-of-sample matches as specified by \code{stan_foot} or \code{mle_foot}.
}
\details{
For Bayesian models fitted via \code{stan_foot} the results probabilities are computed according to the
simulation from the posterior predictive distribution of future (out-of-sample) matches. For MLE models
fitted via the \code{mle_foot} the probabilities are computed by simulating from the MLE estimates.
}
\examples{
\donttest{
if(requireNamespace("engsoccerdata")){
### weekly dynamics, predict the last four weeks
require(engsoccerdata)
require(tidyverse)
require(dplyr)

italy_2000<- italy \%>\%
 dplyr::select(Season, home, visitor, hgoal,vgoal) \%>\%
 dplyr::filter(Season=="2000")

fit <- stan_foot(data = italy_2000,
                 model="double_pois", predict =18,
                 dynamic_type = "weekly")  # double pois

foot_prob(fit, italy_2000, "Inter",
          "Bologna FC")

foot_prob(fit, italy_2000) # all the out-of-sample matches
}
}
}
\author{
Leonardo Egidi \email{legidi@units.it}
}
