% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cropping.R
\name{crop_measurement}
\alias{crop_measurement}
\title{Crop Time Series}
\usage{
crop_measurement(file, path.data = NULL)
}
\arguments{
\item{file}{File path to measurement.}

\item{path.data}{A string character defining where to save the results. If \code{NULL},
data is not stored in a file. Default: \code{NULL}.}
}
\value{
Returns and, if \verb{path.data is not NULL}, saves data in
csv-format in \code{path.data}. \cr
\cr
The tibble has the following format:\tabular{ccc}{
   \strong{\code{t}} \tab  \tab \strong{\code{y}} \cr
   \code{t.1} \tab  \tab \code{y.1} \cr
   \code{...} \tab  \tab \code{...} \cr
   \code{t.n} \tab  \tab \code{y.n} \cr
}
}
\description{
Interactive function to crop a time series.
}
\details{
Select points at start and end of desired part of measurements.
Only the last two points will be
taken into account to allow the user to correct erroneous clicks.

If a measurement contains two distinct regions of bites with a lot of
unnecessary data and/or measurement artefacts in-between (such as user-made
peaks), I recommend to manually copy the RAW data files, give the copy a
new measurement number (as if it was actually a separate measurement), and
crop the distinct parts containing actual bites separately from the two
copies of the file. For more distinct regions, create more copies.

I recommend to not crop the files too much in case baseline corrections are
needed later, because then the \code{baseline_corr()} function will not be able
to figure out where the actual baseline might be. Leaving several seconds
before and after the first and last bite of a series will prevent such
problems.
}
\examples{
# get file path of forceR example file
filename <- forceR_example(type = "raw")

# # crop file without storing result as file - out-commented to pass package tests
# file.cropped <- crop_measurement(file = filename,
#                    path.data = NULL)

# file.cropped

}
