% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FG_Server.R
\name{FG_build}
\alias{FG_build}
\title{Evaluates Figure Generation Code}
\usage{
FG_build(
  state,
  del_row = NULL,
  cmd = NULL,
  element = "unknown",
  desc = "unknown"
)
}
\arguments{
\item{state}{FG state from \code{FG_fetch_state()}}

\item{del_row}{Row number to be deleted (NULL if no rows need to be deleted)}

\item{cmd}{String containing the plotting command.  Set to NULL to initialize a
new figure or force a rebuild after a dataset update.}

\item{element}{Short name for the figure element being performed, eg. point}

\item{desc}{Verbose description for the action being performed}
}
\value{
list with the following elements
\itemize{
 \item{isgood:} Return status of the function.
 \item{msgs:}   Messages to be passed back to the user.
 \item{pages:}  List with each element containing a ggplot object (\code{p}) and the code to generate that object (\code{code})
}
}
\description{
Takes the current state and rebuilds the active figure. If the
elements table has a row flagged for deletion, it will be deleted. If the
cmd input is not NULL it will attempt to append that element to the figure.
}
\examples{
\donttest{
library(formods)
# Within shiny both session and input variables will exist,
# this creates examples here for testing purposes:
sess_res = FG_test_mksession(session=list(), full_session=FALSE)
session = sess_res$session
input   = sess_res$input

# This will create a populated FG state object:
state   = sess_res$state

# This sets the current active figure to Fig_1
state[["FG"]][["current_fig"]]  =  "Fig_1"

# This is a paginated figure, and we can access a specific
# figure using the following:
pg_1 = FG_extract_page(state, 1)
pg_2 = FG_extract_page(state, 2)

# This will give you access to the current figure directly:
current_fig = FG_fetch_current_fig(state)

# For example this will set the key for that figure:
current_fig$key = "Individual profiles by cohort (multiple pages)"

# Once you're done you can put it back into the state:
state = FG_set_current_fig(state, current_fig)

# If you made any changes to the actual figure, this will
# force a rebuild of the current figure:
state = FG_build( state=state, del_row = NULL, cmd = NULL)

# To create a new empty figure you can do this:
state = FG_new_fig(state)
}
}
