% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingPersonLR.R
\name{missingPersonLR}
\alias{missingPersonLR}
\title{Likelihood ratio calculation for missing person identification}
\usage{
missingPersonLR(reference, missing, poi)
}
\arguments{
\item{reference}{A \code{ped} object with attached markers.}

\item{missing}{The ID label of the missing member of \code{reference}.}

\item{poi}{A \code{singleton} object with genotypes for the person of interest.
The marker names of \code{poi} must coincide with those of \code{reference}. The ID
label of \code{poi} is irrelevant.}
}
\value{
The \code{LRresult} object returned by \code{\link[=kinshipLR]{kinshipLR()}}, but without the
trivial \code{H2:H2} comparison.
}
\description{
This is a wrapper function for \code{\link[=kinshipLR]{kinshipLR()}} for the special case of missing
person identification. A person of interest (POI) is matched against a
reference dataset containing genotypes of relatives of the missing person.
}
\examples{
#------------------------------------------------
# Example: Identification of a missing grandchild
#------------------------------------------------

set.seed(2509)

### Reference pedigree with missing grandchild (MP)
x = relabel(linearPed(2), old = 5, new = "MP")

# Simulate reference data for grandmother (5 STR markers)
x = setMarkers(x, locusAttributes = NorwegianFrequencies[1:5])
x = profileSim(x, N = 1, ids = 2)[[1]]

### Person of interest 1: Unrelated
poi1 = singleton("poi1")

# Transfer (empty) markers and simulate genotypes
poi1 = transferMarkers(from = x, to = poi1)
poi1 = profileSim(poi1, N = 1)[[1]]

# Compute LR
lr1 = missingPersonLR(x, missing = "MP", poi = poi1)
lr1
lr1$LRperMarker


### Person of interest 2: The true MP

# Simulate MP conditional on reference, and extract as singleton
poi2 = profileSim(x, N = 1, ids = "MP")[[1]]

# Extract MP as singleton
poi2 = subset(poi2, "MP")

# Compute LR
lr2 = missingPersonLR(x, missing = "MP", poi = poi2)
lr2
lr2$LRperMarker

}
