% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkPairwise.R
\name{checkPairwise}
\alias{checkPairwise}
\title{Check pedigree data for relationship errors}
\usage{
checkPairwise(
  x,
  excludeInbred = TRUE,
  plot = TRUE,
  labels = FALSE,
  LRthreshold = 1000,
  ...
)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{excludeInbred}{A logical, by default TRUE, indicating if inbred
individuals should be excluded from the analysis.}

\item{plot}{A logical (default: TRUE). If TRUE, a plot is produced, showing
the IBD estimates in the IBD triangle.}

\item{labels}{A logical (default: FALSE). If TRUE, labels are included in the
IBD triangle plot.}

\item{LRthreshold}{A positive number (default: 1000). IBD estimates whose LR
exceed this, when compared to the coefficients implied by the pedigree, are
encircled in the plot.}

\item{...}{Further parameters passed on to \code{\link[ribd:ibdTriangle]{ribd::ibdTriangle()}}.}
}
\value{
A data frame containing both the estimated and pedigree-based IBD
coefficients for each pair of typed individuals. The last column contains
the likelihood ratio comparing the estimated coefficients to the
pedigree-based ones.
}
\description{
This function provides a convenient way to check for pedigree errors, given
the available marker data. The function calls \code{\link[=ibdEstimate]{ibdEstimate()}} to estimate IBD
coefficients for all pairs of typed pedigree members, and computes the
likelihood ratio (LR) comparing each estimate to the coefficients implied by
the pedigree. By default, the estimates are shown in a colour-coded plot
where unlikely relationships are easy to spot.
}
\details{
By default, inbred individuals are excluded from the analysis, since pairwise
relationships involving inbred individuals have undefined kappa coefficients
(and therefore no position in the triangle). In some cases it may still be
informative to include their estimates; set \code{excludeInbred = FALSE} to
achieve this.
}
\examples{

### Example with realistic data

x = avuncularPed() |>
  profileSim(markers = NorwegianFrequencies, seed = 1729)

checkPairwise(x)

### Create an error: sample swap 1 <-> 3
als = getAlleles(x)
als[c(1,3), ] = als[c(3,1), ]
y = setAlleles(x, alleles = als)

checkPairwise(y)

\donttest{
# Combined plot of pedigree and IBD estimates
dev.new(height = 5, width = 8, noRStudioGD = TRUE)
layout(rbind(1:2), widths = 2:3)
plot(y, margins = c(4,2,4,2), title = "Swapped 1 - 3")
checkPairwise(y, labels = TRUE)
}

}
\seealso{
\code{\link[=ibdEstimate]{ibdEstimate()}}
}
